#pragma once
#include <FK/FK.h>
#include "FrameController.h"
#include "GuideObject.h"
#include "TrackBall.h"
#include "Input.h"
#include "Fullscreen.h"

enum fkut_SwitchStatus {
	FKUT_SW_RELEASE,
	FKUT_SW_UP,
	FKUT_SW_DOWN,
	FKUT_SW_PRESS
};

enum fkut_PadDirection {
	FKUT_PAD_UP = 32,
	FKUT_PAD_DOWN,
	FKUT_PAD_LEFT,
	FKUT_PAD_RIGHT
};

class CMotionCharactor;

class fkut_SimpleWindow {
private:
	friend class fkut_CubicModel;
	friend class fkut_SpriteModel;

	Fl_Window	*mainWin;
	fk_Window	*drawWin;

	fkut_SimpleWindow		*ref_child;
	fkut_FrameController	fps_admin;
	fkut_GuideObject		guide;
	fk_TrackBall			*tb;
	CFullscreenControler	fsc;

	fk_Scene	scene;
	fk_Scene	*ref_scene;

	fk_Light	lightShape;
	fk_Model	camera, light;
	fk_Model	*ref_camera;

	int		fps;
	bool	tbFlag, childMode;

	static bool	prevKeySt[256], prevSPKeySt[32], prevMouseSt[3];

	fkut_Input		input;
	fkut_InputInfo	prevInput[16], nowInput[16];
	int				inputCount;

	void PushPrevStatus(void);
	void ToggleScreen(void);

public:

	fkut_SimpleWindow(void);
	fkut_SimpleWindow(fkut_SimpleWindow &parent);
	~fkut_SimpleWindow(void);

	// EBhETCYEwiFEFPSEgbN{[[hݒȂ
	void setWindowName(const string &name);
	void setSize(int w, int h);
	void setInnerSize(int x, int y, int w, int h);
	void setBGColor(double r, double g, double b);
	void setFPS(int fps);
	void setTrackBallMode(bool mode);

	// ʒ̃ObhEW\Ɋւ֐
	void showGuide(fkut_GuideMode mode = FKUT_AXIS_X | FKUT_AXIS_Y | FKUT_AXIS_Z | FKUT_GRID_XZ);
	void hideGuide(void);
	void setGuideAxisWidth(double width);
	void setGuideGridWidth(double width);
	void setGuideScale(double scale);
	void setGuideNum(int num);

	// J
	void		setCameraPos(double x, double y, double z);
	void		setCameraFocus(double x, double y, double z);
	void		setCameraModel(fk_Model &model);
	fk_Model *	getCameraModel(void);
	void		setCameraDefault(void);

	// V[
	void		setScene(fk_Scene &scene);
	fk_Scene *	getScene(void);
	void		setSceneDefault(void);

	// f̕\o^E
	void entry(fk_Model &model);
	void entry(fk_Model &model, fkut_GuideObject &guide);
	void entry(fkut_SpriteModel &model);
	void entry(CMotionCharactor &chara);
	void remove(fk_Model &model);
	void remove(fk_Model &model, fkut_GuideObject &guide);
	void remove(fkut_SpriteModel &model);
	void remove(CMotionCharactor &chara);
	// I[NA
	void clearModel(void);

	// EBhE̕\E\EtXN[
	void open(void);
	void close(void);
	void toFullscreen(void);
	void toWindow(void);

	// `EbZ[WR[
	bool update(bool = false);

	// L[{[h
	fkut_SwitchStatus	getKeyStatus(char keyChar);
	fkut_SwitchStatus	getSpecialKeyStatus(fk_SpecialKey keyCode);

	// }EX
	fkut_SwitchStatus	getMouseStatus(fk_MouseButton buttonCode);
	fk_Vector			getMousePosition(void);
	void				setCursorState(bool visible, bool center);

	// Q[pbh
	int					getPadCount(void);
	fkut_SwitchStatus	getPadButtonStatus(int padID, int buttonID);
	fk_Vector			getPadDirection(int padID, int axisID);
	fkut_Input *		getPadManager(void);

	// }EXɂ郂f̃NbN
	bool isModelPicked(fk_Model &model, int pixel = 1, int mouseX = -1, int mouseY = -1);
	// }EXɂFPS_IJ䏈
	void procMouseView(fk_Model &camera, double spinX, double spinY, bool lockSW);

};
