#include "Input.h"
#include <windows.h>

#include <iostream>
using namespace std;

#ifndef RELEASE
#define RELEASE(x)	{if(x){(x)->Release();(x)=NULL;}}
#endif

#pragma warning(disable:4800)

//==================================================
//			RXgN^
//==================================================
fkut_Input::fkut_Input()
{
	m_hwnd = NULL;

	m_MouseWorldPos.x = 0;
	m_MouseWorldPos.y = 0;
	m_MouseLocalPos.x = 0;
	m_MouseLocalPos.y = 0;
	m_MouseWheel = 0;
	memset(m_Button, 0, sizeof(bool) * MOUSE_BUTTON_MAX);
	memset(m_LastButton, 0, sizeof(bool) * MOUSE_BUTTON_MAX);

	m_JoyCount = 0;
	m_Input = NULL;
	m_KeyBoardDevice = NULL;
	m_MouseDevice = NULL;
	for(DWORD i = 0; i < INPUT_DEVICE_NUM; i++) {
		m_JoyStciDevice[i] = NULL;
		
		for(int j = 0; j < BUTTON_NUM; j++) {
			buttonSwap[i][j] = j;
		}

		setBorder(i, 500, 500);
		setMinMax(i, 200, 900);

		setAxisSwap(i, AXIS1_X, AXIS_X_POS);
		setAxisSwap(i, AXIS1_Y, AXIS_Y_POS);
		setAxisSwap(i, AXIS2_X, AXIS_Z_POS);
		setAxisSwap(i, AXIS2_Y, AXIS_RZ_POS);
		setAxisSwap(i, AXIS3_X, AXIS_RX_POS);
		setAxisSwap(i, AXIS3_Y, AXIS_RY_POS);
	}
	m_JoyButton = NULL;

	setAxisAssign(0, DIK_UP, DIK_DOWN, DIK_LEFT, DIK_RIGHT);
	setAxisAssign(1, 0, 0, 0, 0);
	setAxisAssign(2, 0, 0, 0, 0);
	setPOVAssign(DIK_NUMPAD7, DIK_NUMPAD8, DIK_NUMPAD9, DIK_NUMPAD4, DIK_NUMPAD6, DIK_NUMPAD1, DIK_NUMPAD2, DIK_NUMPAD3);
	for(int i = 0; i < BUTTON_NUM; i++) {
		setKeyAssign(i, 0);
	}

	return;
}

//===================================================
//			fXgN^
//===================================================
fkut_Input::~fkut_Input()
{
	uninit();
}

//===================================================
//	
//===================================================
HRESULT fkut_Input::init(HINSTANCE hinst, HWND hwnd)
{
	m_hwnd = hwnd;
	HRESULT hr;

	// DirectInput ̍쐬
	hr = DirectInput8Create(hinst, DIRECTINPUT_VERSION, IID_IDirectInput8, (LPVOID*)&m_Input, NULL);
	if(FAILED(hr)) return hr;

	//==============================
	//	L[{[h
	//==============================
	// L[{[hfoCX̍쐬
	hr = m_Input->CreateDevice(GUID_SysKeyboard, &m_KeyBoardDevice, NULL); 
	if(FAILED(hr)) return hr;

	// 擾f[^tH[}bg̐ݒ
	hr = m_KeyBoardDevice->SetDataFormat(&c_dfDIKeyboard);
	if(FAILED(hr)) return hr;

	// xݒ
	hr = m_KeyBoardDevice->SetCooperativeLevel(hwnd, DISCL_FOREGROUND | DISCL_NONEXCLUSIVE);
	if(FAILED(hr)) return hr;

	ZeroMemory(m_Key, sizeof(m_Key));

	// obt@TCY̎w
	DIPROPDWORD dipdw;
	dipdw.diph.dwSize		= sizeof(DIPROPDWORD);
	dipdw.diph.dwHeaderSize	= sizeof(DIPROPHEADER);
	dipdw.diph.dwObj		= 0;
	dipdw.diph.dwHow		= DIPH_DEVICE;
	dipdw.dwData			= DIMGR_BUFFER_SIZE; // Arbitary buffer size

	if(FAILED(hr = m_KeyBoardDevice->SetProperty(DIPROP_BUFFERSIZE, &dipdw.diph))) return hr;

	// ANZX擾
	if(m_KeyBoardDevice) m_KeyBoardDevice->Acquire(); 

	//==============================
	//}EX
	//==============================
	hr = m_Input->CreateDevice(GUID_SysMouse, &m_MouseDevice, NULL); 
	if(FAILED(hr)) return hr;
	
	// f[^`ݒ
	hr = m_MouseDevice->SetDataFormat(&c_dfDIMouse2);
	if(FAILED(hr)) return hr;

	//[hݒitHAOEhr[hj
	hr = m_MouseDevice->SetCooperativeLevel(hwnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
	if(FAILED(hr)) return hr;

	DIPROPDWORD dimouse;
	dimouse.diph.dwSize			= sizeof(dimouse); 
	dimouse.diph.dwHeaderSize	= sizeof(dimouse.diph); 
	dimouse.diph.dwObj			= 0;
	dimouse.diph.dwHow			= DIPH_DEVICE;
	dimouse.dwData				= DIPROPAXISMODE_REL;	
	//dimouse.dwData			= DIPROPAXISMODE_ABS;	// Βl[h̏ꍇ
	hr = m_MouseDevice->SetProperty(DIPROP_AXISMODE, &dimouse.diph);
	if(FAILED(hr)) return hr;

	// obt@OEf[^擾邽߁Aobt@ETCYݒ
	dimouse.dwData = DIMGR_BUFFER_SIZE;
	hr =m_MouseDevice->SetProperty(DIPROP_BUFFERSIZE, &dimouse.diph);
	if(FAILED(hr)) return hr;
	m_MouseDevice->Acquire();


	//=================================
	//WCXeBbN
	//=================================

	m_JoyMaxCount = ::joyGetNumDevs();
	
	hr = m_Input->EnumDevices(DI8DEVCLASS_GAMECTRL, EnumJoysticksCallback, (void*)this, DIEDFL_ATTACHEDONLY);
	if(FAILED(hr)) return hr;

	DIPROPDWORD diprop;
	diprop.diph.dwSize			= sizeof(diprop); 
	diprop.diph.dwHeaderSize	= sizeof(diprop.diph); 
	diprop.diph.dwObj			= 0;
	diprop.diph.dwHow			= DIPH_DEVICE;
	diprop.dwData				= DIPROPAXISMODE_ABS;

	m_JoyButton = new fkut_InputInfo[m_JoyCount];
	
 	for(DWORD i = 0; i < m_JoyCount; i++) {
		hr = m_JoyStciDevice[i]->SetDataFormat(&c_dfDIJoystick);
		if(FAILED(hr)) {
			m_JoyCount--;
			return hr;
		}

		hr = m_JoyStciDevice[i]->SetCooperativeLevel(hwnd, DISCL_FOREGROUND | DISCL_NONEXCLUSIVE);
		if(FAILED(hr)) {
			m_JoyCount--;
			return hr;
		}

		hr = m_JoyStciDevice[i]->EnumObjects(EnumSizesCallback, (void*)m_JoyStciDevice[i], DIDFT_AXIS);
		if(FAILED(hr)) {
			m_JoyCount--;
			return hr;
		}

		hr = m_JoyStciDevice[i]->SetProperty(DIPROP_AXISMODE, &diprop.diph);
		if(FAILED(hr)) {
			// 2ڈȍ~̃foCXł̓G[f炵
			// 1ڂ̏ꍇ̓G[ŋ~A2߈ȍ~ł̓X[
			if(i == 0) {
				m_JoyCount--;
				return hr;
			}
		}

		// obt@OEf[^擾邽߁Aobt@ETCYݒ
		diprop.dwData = DIMGR_BUFFER_SIZE;
		hr = m_JoyStciDevice[i]->SetProperty(DIPROP_BUFFERSIZE, &diprop.diph);
		if(FAILED(hr)) {
			m_JoyCount--;
			return hr;
		}

		m_JoyStciDevice[i]->Acquire();

		ZeroMemory(&m_JoyButton[i], sizeof(fkut_InputInfo));
		m_JoyButton[i].pov = -1;
	}

	return S_OK;
}

void fkut_Input::setBorder(int id, int inAllowX, int inAllowY)
{
	if(id < 0 || id >= INPUT_DEVICE_NUM) return;

	m_AllowX[id] = inAllowX;
	m_AllowY[id] = inAllowY;

	return;
}

void fkut_Input::setBorder(int inAllowX, int inAllowY)
{
	setBorder(0, inAllowX, inAllowY);
}

void fkut_Input::setMinMax(int id, int inMin, int inMax)
{
	if(id < 0 || id >= INPUT_DEVICE_NUM) return;
	if(inMin > inMax) return;

	m_AllowMin[id] = inMin;
	m_AllowMax[id] = inMax;

	return;
}

void fkut_Input::setMinMax(int inMin, int inMax)
{
	setMinMax(0, inMin, inMax);
}

//-----------------------------------------------------------
//	I
//-----------------------------------------------------------
HRESULT fkut_Input::uninit()
{	
	//============================
	//L[{[h
	//============================
	if(m_KeyBoardDevice != NULL) {
		m_KeyBoardDevice->Unacquire();
		RELEASE(m_KeyBoardDevice);
	}

	//============================
	//}EX
	//============================
	if(m_MouseDevice != NULL) {
		m_MouseDevice->Unacquire();
		RELEASE(m_MouseDevice);
	}

	//==============================
	//@WCXeBbN
	//==============================
	for(DWORD i = 0; i < m_JoyCount; i++) {
		if(m_JoyStciDevice[i]) {
			m_JoyStciDevice[i]->Unacquire(); 
			RELEASE(m_JoyStciDevice[i]);
		}
	}
	
	if(m_JoyButton != NULL) {
		delete []m_JoyButton;
		m_JoyButton = NULL;
	}

	//================================
	//ŌDirectInput
	//================================
	RELEASE(m_Input);

	return S_OK;
}

//===============================================
//L[擾܂B
//===============================================
bool fkut_Input::GetKey(const DWORD keycode)
{
	return m_Key[keycode];
}


//==================================
//SẴfoCXAbvf[g܂B
//==================================
HRESULT fkut_Input::update()
{
	bool A = UpdateMouse() == S_OK;
	bool B = UpdateKey() == S_OK;
	bool C = UpdateJoy() == S_OK;
	if(A && B && C) {
		return S_OK;
	}
	return E_FAIL;
}



//==================================================
//L[Abvf[g܂B
//==================================================
HRESULT fkut_Input::UpdateKey()
{
	DWORD	elements;
	HRESULT	hr;

    if(NULL == m_KeyBoardDevice) {
        return S_OK;
	}
    elements = DIMGR_BUFFER_SIZE;
    hr = m_KeyBoardDevice->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), m_DeviceObject, &elements, 0);
    if(hr != DI_OK) {
		if(m_KeyBoardDevice->Acquire() != DI_OK) {
			return E_FAIL;
		}
		m_KeyBoardDevice->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), m_DeviceObject, &elements, 0);
	}

	for(DWORD i = 0; i < elements; i++) {
		m_Key[m_DeviceObject[i].dwOfs] = (bool)((m_DeviceObject[i].dwData & 0x80) >> 7);
	}

	return S_OK;
}

//====================================
//Mouse̍XV
//====================================
HRESULT fkut_Input::UpdateMouse()
{
	memcpy(m_LastButton, m_Button, sizeof(bool) * MOUSE_BUTTON_MAX);
	GetCursorPos(&m_MouseWorldPos);
	ScreenToClient(m_hwnd,&m_MouseWorldPos);

	m_MouseLocalPos.x = 0;
	m_MouseLocalPos.y = 0;
	m_MouseWheel = 0;
	DWORD dwItems = DIMGR_BUFFER_SIZE;

	if(NULL == m_MouseDevice) {
        return S_OK;
	}
	
	HRESULT hr = m_MouseDevice->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), m_DeviceObject, &dwItems, 0);
	if(hr != S_OK) {
		if(m_MouseDevice->Acquire() != DI_OK) {
			return E_FAIL;
		}
		m_MouseDevice->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),m_DeviceObject,&dwItems, 0);
	}

	for(DWORD i = 0; i < dwItems; i++) {  
		switch(m_DeviceObject[i].dwOfs) {
		case DIMOFS_X:
			m_MouseLocalPos.x += m_DeviceObject[i].dwData;
			break;
		case DIMOFS_Y:
			m_MouseLocalPos.y += m_DeviceObject[i].dwData;
			break;
		case DIMOFS_Z:
			m_MouseWheel += m_DeviceObject[i].dwData;
			break;
		default:
			m_Button[m_DeviceObject[i].dwOfs - DIMOFS_BUTTON0] = (m_DeviceObject[i].dwData & 0x80) >> 7;
			break;
		}
	}

	//m_MouseWorldPos.x += m_MouseLocalPos.x;
	//m_MouseWorldPos.y += m_MouseLocalPos.y;

    return S_OK;
}

int fkut_Input::GetMouseWheel()
{
	return m_MouseWheel;
}

short fkut_Input::AdjustParam(int id, short argRawData)
{
	short	retVal;

	if(argRawData < 0) {
		retVal = argRawData + m_AllowMin[id];
		if(retVal > 0) retVal = 0;
	} else {
		retVal = argRawData - m_AllowMin[id];
		if(retVal < 0) retVal = 0;
	}

	retVal = short(double(retVal)*(1000.0/double(m_AllowMax[id]-m_AllowMin[id])));

	if(retVal > 1000) retVal = 1000;
	if(retVal < -1000) retVal = -1000;

	return retVal;
}

void fkut_Input::SetAxisParam(int id, int rawAxis, short param)
{
	short value = param * abs(axisSwap[id][rawAxis])/axisSwap[id][rawAxis];

	switch(abs(axisSwap[id][rawAxis])) {
	case AXIS1_X:
		m_JoyButton[id].x[0] = value;
		break;
	case AXIS1_Y:
		m_JoyButton[id].y[0] = value;
		break;
	case AXIS2_X:
		m_JoyButton[id].x[1] = value;
		break;
	case AXIS2_Y:
		m_JoyButton[id].y[1] = value;
		break;
	case AXIS3_X:
		m_JoyButton[id].x[2] = value;
		break;
	case AXIS3_Y:
		m_JoyButton[id].y[2] = value;
		break;
	default:
		break;
	}

	return;
}

//====================================
//Joy̍XV
//====================================
HRESULT fkut_Input::UpdateJoy()
{
	if(NULL == m_JoyStciDevice[0]) {
        return S_OK;
	}

	HRESULT		hr;
	DIJOYSTATE	dijs;

	for(DWORD i = 0; i < m_JoyCount; i++) {
		hr = m_JoyStciDevice[i]->Poll();
		if(FAILED(hr)) {
			if(m_JoyStciDevice[i]->Acquire() != DI_OK) {
				memset(&m_JoyButton[i], 0, sizeof(m_JoyButton[i]));
				m_JoyButton[i].pov = -1;
				return E_FAIL;
			}
			hr = m_JoyStciDevice[i]->Poll();
			if(FAILED(hr)) {
				memset(&m_JoyButton[i], 0, sizeof(m_JoyButton[i]));
				m_JoyButton[i].pov = -1;
				return E_FAIL;
			}
		}

		DWORD dwItems = DIMGR_BUFFER_SIZE;
		m_JoyStciDevice[i]->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),m_DeviceObject,&dwItems, 0);
		m_JoyStciDevice[i]->GetDeviceState(sizeof(DIJOYSTATE), &dijs);
	
	
		//-------------------------------------------------------------------------
		//ȍ~{^̍XV
		//-------------------------------------------------------------------------
        fkut_InputInfo &joyButton = m_JoyButton[i];

		for(DWORD j = 0; j < dwItems; j++) {  
			switch(m_DeviceObject[j].dwOfs) {
			case DIJOFS_X:
				//joyButton.x[0] = AdjustParam(i, (short)m_DeviceObject[j].dwData);
				SetAxisParam(i, 0, AdjustParam(i, (short)m_DeviceObject[j].dwData));
				break;
			case DIJOFS_Y:
				//joyButton.y[0] = AdjustParam(i, (short)m_DeviceObject[j].dwData);
				SetAxisParam(i, 1, AdjustParam(i, (short)m_DeviceObject[j].dwData));
				break;
			case DIJOFS_Z:
				//joyButton.x[1] = AdjustParam(i, (short)m_DeviceObject[j].dwData);
				SetAxisParam(i, 2, AdjustParam(i, (short)m_DeviceObject[j].dwData));
				break;
			case DIJOFS_RZ:
				//joyButton.y[1] = AdjustParam(i, (short)m_DeviceObject[j].dwData);
				SetAxisParam(i, 5, AdjustParam(i, (short)m_DeviceObject[j].dwData));
				break;
			case DIJOFS_RX:
				//joyButton.x[2] = AdjustParam(i, (short)m_DeviceObject[j].dwData);
				SetAxisParam(i, 3, AdjustParam(i, (short)m_DeviceObject[j].dwData));
				break;
			case DIJOFS_RY:
				//joyButton.y[2] = AdjustParam(i, (short)m_DeviceObject[j].dwData);
				SetAxisParam(i, 4, AdjustParam(i, (short)m_DeviceObject[j].dwData));
				break;
			default:
				// joyButton.button[m_DeviceObject[j].dwOfs - DIJOFS_BUTTON0] = (m_DeviceObject[j].dwData & 0x80) >> 7;
				break;
			}
		}

		//-------------------------------------------------------------------------
		//\{^XV
		//-------------------------------------------------------------------------
		if(joyButton.y[0] <= -m_AllowY[i]) {
			joyButton.up = true;
		} else {
			joyButton.up = false;
		}
		if(joyButton.y[0] >= m_AllowY[i]) {
			joyButton.down = true;
		} else {
			joyButton.down = false;
		}
		if(joyButton.x[0] >= m_AllowX[i]) {
			joyButton.right = true;
		} else {
			joyButton.right = false;
		}
		if(joyButton.x[0] <= -m_AllowX[i]) {
			joyButton.left = true;
		} else {
			joyButton.left = false;
		}

		joyButton.pov = (int)dijs.rgdwPOV[0];

		for(int j = 0; j < BUTTON_NUM; j++) {
			if(dijs.rgbButtons[j] & 0x80) {
				joyButton.button[buttonSwap[i][j]] = true;
			} else {
				joyButton.button[buttonSwap[i][j]] = false;
			}
		}

		for(std::map<int, AxisParam>::iterator it = axisParams[i].begin(); it != axisParams[i].end(); it++) {
			switch(it->first) {
			case AXIS1_X:
				if(joyButton.x[0] >= it->second.border) {
					joyButton.button[it->second.pos] = true;
				} else {
					joyButton.button[it->second.pos] = false;
				}
				if(joyButton.x[0] <= -(it->second.border)) {
					joyButton.button[it->second.neg] = true;
				} else {
					joyButton.button[it->second.neg] = false;
				}
				break;
			case AXIS1_Y:
				if(joyButton.y[0] >= it->second.border) {
					joyButton.button[it->second.pos] = true;
				} else {
					joyButton.button[it->second.pos] = false;
				}
				if(joyButton.y[0] <= -(it->second.border)) {
					joyButton.button[it->second.neg] = true;
				} else {
					joyButton.button[it->second.neg] = false;
				}
				break;
			case AXIS2_X:
				if(joyButton.x[1] >= it->second.border) {
					joyButton.button[it->second.pos] = true;
				} else {
					joyButton.button[it->second.pos] = false;
				}
				if(joyButton.x[1] <= -(it->second.border)) {
					joyButton.button[it->second.neg] = true;
				} else {
					joyButton.button[it->second.neg] = false;
				}
				break;
			case AXIS2_Y:
				if(joyButton.y[1] >= it->second.border) {
					joyButton.button[it->second.pos] = true;
				} else {
					joyButton.button[it->second.pos] = false;
				}
				if(joyButton.y[1] <= -(it->second.border)) {
					joyButton.button[it->second.neg] = true;
				} else {
					joyButton.button[it->second.neg] = false;
				}
				break;
			case AXIS3_X:
				if(joyButton.x[2] >= it->second.border) {
					joyButton.button[it->second.pos] = true;
				} else {
					joyButton.button[it->second.pos] = false;
				}
				if(joyButton.x[2] <= -(it->second.border)) {
					joyButton.button[it->second.neg] = true;
				} else {
					joyButton.button[it->second.neg] = false;
				}
				break;
			case AXIS3_Y:
				if(joyButton.y[2] >= it->second.border) {
					joyButton.button[it->second.pos] = true;
				} else {
					joyButton.button[it->second.pos] = false;
				}
				if(joyButton.y[2] <= -(it->second.border)) {
					joyButton.button[it->second.neg] = true;
				} else {
					joyButton.button[it->second.neg] = false;
				}
				break;
			default:
				break;
			}
		}
	}

	return S_OK;
}

BOOL CALLBACK fkut_Input::EnumSizesCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID lpvRef)
{
	//------------------------------------------------------------------------------
	//foCX̐ݒ
	//------------------------------------------------------------------------------
	DIPROPRANGE diprg;
	ZeroMemory(&diprg,sizeof(diprg));
	diprg.diph.dwSize = sizeof(diprg); 
	diprg.diph.dwHeaderSize	= sizeof(diprg.diph); 
	diprg.diph.dwObj = lpddoi->dwType;
	diprg.diph.dwHow = DIPH_BYID;
	diprg.lMin = -1000;
	diprg.lMax = +1000;

	//------------------------------------------------------------------------------
	//foCX̐ݒ
	//------------------------------------------------------------------------------
	LPDIRECTINPUTDEVICE8 lpJoy = (LPDIRECTINPUTDEVICE8)lpvRef;
	HRESULT hr;
	hr = lpJoy->SetProperty(DIPROP_RANGE, &diprg.diph);
	if(FAILED(hr)) {
		return DIENUM_STOP;
	}
	return DIENUM_CONTINUE;
}

//------------------------------------------------------------------------------
//WCXeBbN񋓂R[obN֐
//------------------------------------------------------------------------------
BOOL CALLBACK fkut_Input::EnumJoysticksCallback(const DIDEVICEINSTANCE* lpddi, LPVOID lpContext )
{
	//--------------------------------------------------------------------------
	//foCX̊蓖
	//--------------------------------------------------------------------------
	fkut_Input* joyStick = (fkut_Input*)lpContext;	
	joyStick->m_DevCaps.dwSize = sizeof(DIDEVCAPS);
	joyStick->m_Input->CreateDevice(lpddi->guidInstance, &joyStick->m_JoyStciDevice[joyStick->m_JoyCount],NULL);
	joyStick->m_JoyStciDevice[joyStick->getJoyCount()]->GetCapabilities(&joyStick->m_DevCaps);
	//--------------------------------------------------------------------------
	//WCXeBbNőɂȂĂ狭IɃXgbv
	//---------------------------------------------------------------------------
	if(++(joyStick->m_JoyCount) == joyStick->m_JoyMaxCount) {
		return DIENUM_STOP;
	}
	//--------------------------------------------------------------------------
	//őɂȂĂȂ̂ŗ񋓂܂
	//--------------------------------------------------------------------------
	return DIENUM_CONTINUE;
}

//==================================
//Mouse{^擾
//==================================
bool fkut_Input::GetMouseButton(DWORD key)
{
	if(key >= MOUSE_BUTTON_MAX) {
		return NULL;
	}
	return m_Button[key];
}

bool fkut_Input::GetLastMouseButton(DWORD key)
{
	if(key >= MOUSE_BUTTON_MAX) {
		return NULL;
	}
	return m_LastButton[key];
}

//==================================
//JoyStick擾
//==================================
fkut_InputInfo* fkut_Input::getJoyStick(DWORD dwNum)
{
	if(dwNum >= m_JoyCount) {
		return NULL;
	}
	return &m_JoyButton[dwNum];
}

//==================================
//JoyStick̐擾
//==================================
DWORD fkut_Input::getJoyCount()
{
	return m_JoyCount;
}

//==================================
//Mousẽ[JW擾
//==================================
POINT& fkut_Input::GetMouseLocalPos()
{
	return m_MouseLocalPos;
}

//==================================
//Mouse̐΍W擾
//==================================
POINT& fkut_Input::GetMouseWorldPos()
{
	return m_MouseWorldPos;
}


void fkut_Input::setButtonSwap(int joyIndex, int id, int raw)
{
	if(joyIndex >= INPUT_DEVICE_NUM) {
		return;
	}

	buttonSwap[joyIndex][raw] = id;

	return;
}

void fkut_Input::setAxisSwap(int joyIndex, fkut_AxisDirection id, fkut_RawAxis raw)
{
	if(joyIndex >= INPUT_DEVICE_NUM) {
		return;
	}

	if(raw%2 == 1) {
		axisSwap[joyIndex][raw/2] = -id;
	} else {
		axisSwap[joyIndex][raw/2] =  id;
	}

	return;
}

void fkut_Input::setAxisToButton(int joyIndex, fkut_AxisDirection axisID, int posBtn, int negBtn, int border)
{
	AxisParam	param;

	param.pos = posBtn;
	param.neg = negBtn;
	param.border = border;

	axisParams[joyIndex][axisID] = param;

	return;
}

void fkut_Input::clearAxisToButton(int joyIndex)
{
	axisParams[joyIndex].clear();

	return;
}

void fkut_Input::setKeyAssign(int id, DWORD keycode)
{
	if(id >= 0 && id < BUTTON_NUM) {
		keyMap[id] = keycode;
	}

	return;
}

void fkut_Input::setAxisAssign(int axis_id, DWORD up, DWORD dn, DWORD lt, DWORD rt)
{
	if(axis_id == 0 || axis_id == 1 || axis_id == 2) {
		axisMap[axis_id*4+0] = up;
		axisMap[axis_id*4+1] = dn;
		axisMap[axis_id*4+2] = lt;
		axisMap[axis_id*4+3] = rt;
	}

	return;
}

void fkut_Input::setPOVAssign(DWORD ul, DWORD u, DWORD ur, DWORD l, DWORD r, DWORD dl, DWORD d, DWORD dr)
{
	povMap[0] = ul;
	povMap[1] = u;
	povMap[2] = ur;
	povMap[3] = l;
	povMap[4] = r;
	povMap[5] = dl;
	povMap[6] = d;
	povMap[7] = dr;

	return;
}

fkut_InputInfo fkut_Input::getInputStatus(int index)
{
	fkut_InputInfo	retVal;

	memset(&retVal, 0, sizeof(fkut_InputInfo));

	fkut_InputInfo *joy_in = getJoyStick(index);

	if(joy_in != NULL) {
		retVal = *joy_in;
	} else if(index == 0) {
		// 1
		retVal.x[0] = 0;	retVal.y[0] = 0;
		retVal.up    = GetKey(axisMap[0]);	retVal.y[0] += retVal.up    ? -1000 : 0;
		retVal.down	 = GetKey(axisMap[1]);	retVal.y[0] += retVal.down  ?  1000 : 0;
		retVal.left  = GetKey(axisMap[2]);	retVal.x[0] += retVal.left  ? -1000 : 0;
		retVal.right = GetKey(axisMap[3]);	retVal.x[0] += retVal.right ?  1000 : 0;

		// 2
		retVal.x[1] = 0;	retVal.y[1] = 0;
		retVal.y[1] += GetKey(axisMap[4]) ? -1000 : 0;
		retVal.y[1] += GetKey(axisMap[5]) ?  1000 : 0;
		retVal.x[1] += GetKey(axisMap[6]) ? -1000 : 0;
		retVal.x[1] += GetKey(axisMap[7]) ?  1000 : 0;

		// 3
		retVal.x[2] = 0;	retVal.y[2] = 0;
		retVal.y[2] += GetKey(axisMap[8])  ? -1000 : 0;
		retVal.y[2] += GetKey(axisMap[9])  ?  1000 : 0;
		retVal.x[2] += GetKey(axisMap[10]) ? -1000 : 0;
		retVal.x[2] += GetKey(axisMap[11]) ?  1000 : 0;

		// POV
		retVal.pov = -1;
		if(GetKey(povMap[0])) retVal.pov = 31500;
		if(GetKey(povMap[1])) retVal.pov = 0;
		if(GetKey(povMap[2])) retVal.pov = 4500;
		if(GetKey(povMap[3])) retVal.pov = 27000;
		if(GetKey(povMap[4])) retVal.pov = 9000;
		if(GetKey(povMap[5])) retVal.pov = 22500;
		if(GetKey(povMap[6])) retVal.pov = 18000;
		if(GetKey(povMap[7])) retVal.pov = 13500;

		// {^
		for(int i = 0; i < BUTTON_NUM; i++) {
			retVal.button[i] = GetKey(keyMap[i]);
		}
	}

	return retVal;
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   