#pragma once
#include <FK/Line.h>
#include <FK/Model.h>

typedef unsigned int fkut_GuideMode;

const fkut_GuideMode FKUT_NO_GUIDE = 0x0000;
const fkut_GuideMode FKUT_AXIS_X   = 0x0001;
const fkut_GuideMode FKUT_AXIS_Y   = 0x0002;
const fkut_GuideMode FKUT_AXIS_Z   = 0x0004;
const fkut_GuideMode FKUT_GRID_XZ  = 0x0008;
const fkut_GuideMode FKUT_GRID_XY  = 0x0010;
const fkut_GuideMode FKUT_GRID_YZ  = 0x0020;
const fkut_GuideMode FKUT_ALL_GUIDE
	= FKUT_AXIS_X | FKUT_AXIS_Y | FKUT_AXIS_Z | FKUT_GRID_XZ | FKUT_GRID_XY | FKUT_GRID_YZ;

class fk_Scene;

class fkut_GuideObject {
private:
	fk_Line			grid;
	fk_Model		gridModel[3];
	fk_Line			axis[3];
	fk_Model		axisModel[3];

	int	num;
	double scale;

public:
	fkut_GuideObject(void);
	~fkut_GuideObject(void);

	void setAxisWidth(double width);
	void setGridWidth(double width);

	void setScale(double scale);
	void setNum(int num);
	void setParent(fk_Model *);

	void entryScene(fk_Scene *scene,
		fkut_GuideMode = FKUT_AXIS_X | FKUT_AXIS_Y | FKUT_AXIS_Z | FKUT_GRID_XZ);
	void removeScene(fk_Scene *scene, fkut_GuideMode = FKUT_NO_GUIDE);
};
