// CFullscreenControlerNX
// WIN32API𗘗pSȃtXN[[h񋟂܂B

#include "Fullscreen.h"

/*
#include <d3d9.h>
#pragma comment(lib,"d3d9.lib")
static LPDIRECT3D9			g_lpD3D = NULL;
static LPDIRECT3DDEVICE9	g_lpD3DDEV = NULL;
*/

// O[oϐ
static windowstate	WindowState[MAX_WINDOWNUMBER];
static int			iWindowNumber;					// ʏ̃EChE

// EChEʒuۑ̃R[obN֐
BOOL CALLBACK EnumWindowsSaveFunc(HWND hWnd, LPARAM lParam)
{
	char szWindowName[MAX_NAMELENGTH];
	char szClassName[MAX_NAMELENGTH];

	// EChEƃNX̎擾
	GetWindowText(hWnd, szWindowName, MAX_NAMELENGTH);
	GetClassName(hWnd, szClassName, MAX_NAMELENGTH);

	// ĂEChEZNg
	if(IsWindowVisible(hWnd) &&
		GetWindow(hWnd, GW_OWNER) == NULL &&
		lstrlen(szWindowName) > 0 &&
		lstrcmp(szClassName, "Progman") != 0 ){

		// EChEʒuۑ
		if(iWindowNumber < MAX_WINDOWNUMBER){
			WindowState[iWindowNumber].WindowPlacement.length = sizeof(WINDOWPLACEMENT);
			GetWindowPlacement(hWnd, &WindowState[iWindowNumber].WindowPlacement);
			WindowState[iWindowNumber].hWnd = hWnd;

			++iWindowNumber;
		}
	}

	return TRUE;
}

// EChEʒuČ̃R[obN֐
BOOL CALLBACK EnumWindowsLoadFunc(HWND hWnd, LPARAM lParam)
{
	char szWindowName[MAX_NAMELENGTH];
	int  i;

	// EChE̎擾
	GetWindowText(hWnd, szWindowName, MAX_NAMELENGTH);

	// ۑĂEChE
	for(i = 0; i < iWindowNumber; i++){
		if(WindowState[i].hWnd == hWnd) break;
	}

	// 猳̏ꏊɖ߂
	if(i != iWindowNumber){
		SetWindowPlacement(hWnd, &WindowState[i].WindowPlacement);
	}

	return TRUE;
}

// vCx[gRXgN^
CFullscreenControler::CFullscreenControler()
{
	pFlWnd = NULL;
	hFlWnd = NULL;
	pFkWnd = NULL;
	fscW = fscH = 0;

	return;
}
// vCx[gfXgN^
CFullscreenControler::~CFullscreenControler()
{
	return;
}

// EChEʒuۑ
BOOL CFullscreenControler::SaveWindowPosition()
{
	iWindowNumber = 0;
	if(EnumWindows(EnumWindowsSaveFunc, NULL) == 0)	return FALSE;

	return TRUE;
}

// EChEʒuČ
BOOL CFullscreenControler::LoadWindowPosition()
{
	if(EnumWindows(EnumWindowsLoadFunc, NULL) == 0)	return FALSE;

	return TRUE;
}

// tXN[
BOOL CFullscreenControler::ChangeScreen(HWND hWnd, int iFlag, int nWidth, int nHeight)
{
	DEVMODE DeviceMode;
	memset(&DeviceMode, 0, sizeof(DeviceMode));

	// tXN[ɂł
	if(iFlag == SCMODE_FULLSCREEN){

		// ݂̐F擾
		HDC hDC = GetDC(hWnd);
		int ScreenColors = GetDeviceCaps(hDC, BITSPIXEL);
		int ScreenWidth = GetDeviceCaps(hDC, HORZRES);
		int ScreenHeight = GetDeviceCaps(hDC, VERTRES);
		int ScreenRefresh = GetDeviceCaps(hDC, VREFRESH);
		ReleaseDC(hWnd, hDC);

		// ̃XN[TCYꏏȂ炢Ȃ
		if(ScreenWidth != nWidth || ScreenHeight != nHeight) {
			// tXN[[hT
			int	i = 0, just = -1, overlap = 0;
			while(true){
				if(!EnumDisplaySettings(NULL, i, &DeviceMode)) break;
				if(DeviceMode.dmPelsWidth == (unsigned int)nWidth &&
					DeviceMode.dmPelsHeight	== (unsigned int)nHeight &&
					DeviceMode.dmBitsPerPel	== (DWORD)ScreenColors &&
					DeviceMode.dmDisplayFrequency == 60) {
						just = i;
						break;
				}
				if(DeviceMode.dmPelsWidth >= (unsigned int)nWidth &&
					DeviceMode.dmPelsHeight	>= (unsigned int)nHeight &&
					DeviceMode.dmBitsPerPel	== (DWORD)ScreenColors &&
					DeviceMode.dmDisplayFrequency == 60) {
						just = i;
						overlap = 1;
						break;
				}
				i++;
			}
			if(just == -1) return FALSE;
			EnumDisplaySettings(NULL, just, &DeviceMode);
			fscW = DeviceMode.dmPelsWidth;
			fscH = DeviceMode.dmPelsHeight;
			DeviceMode.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT | DM_DISPLAYFREQUENCY;

			// tXN[ɕύX
			if(ChangeDisplaySettings(&DeviceMode, CDS_FULLSCREEN) != DISP_CHANGE_SUCCESSFUL) {
				fscW = fscH = 0;
				return FALSE;
			}
		} else {
			fscW = nWidth;
			fscH = nHeight;
		}
		// ɍőOʐݒp
		SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0,
			SWP_SHOWWINDOW|SWP_NOMOVE|SWP_NOSIZE);
	}

	// ̉ʃ[hɖ߂ł
	if(iFlag == SCMODE_WINDOW) {
		ChangeDisplaySettings(NULL, 0);
		// ɍőOʐݒ
		SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0,
			SWP_SHOWWINDOW|SWP_NOMOVE|SWP_NOSIZE);
		fscW = fscH = 0;
	}

	return TRUE;
}

// oCh
void CFullscreenControler::init(Fl_Window *p_main_win, fk_Window *p_draw_win)
{
	// |C^󂯎
	pFlWnd = p_main_win;		// Fl_WindowpɃ|C^擾
	hFlWnd = fl_xid(pFlWnd);	// 𑜓xύXpɃEBhEnh擾
	pFkWnd = p_draw_win;
	mode = false;

	return;
}

/*
bool CFullscreenControler::changeByD3D(bool argMode)
{
	// D3D9 IuWFNg̓O[ołЂƂ
	if(g_lpD3D == NULL) {
		if(NULL == (g_lpD3D = Direct3DCreate9(D3D_SDK_VERSION))) {
			MessageBox(hFlWnd, "Direct3D ̍쐬Ɏs܂B", "FK_D3D", MB_OK | MB_ICONSTOP);
			return false;
		}
	}

	// ݂̉ʃ[h擾
    D3DDISPLAYMODE			d3ddm;
    if(FAILED(g_lpD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &d3ddm))) return false;

	// Direct3D p[^̐ݒ
	D3DPRESENT_PARAMETERS	d3dpp;
	ZeroMemory(&d3dpp, sizeof(D3DPRESENT_PARAMETERS));

	// tXN[[hƂăp[^Zbg
	d3dpp.BackBufferCount = 0;
	d3dpp.Windowed = FALSE;
	d3dpp.BackBufferWidth = nW;
	d3dpp.BackBufferHeight = nH;
	// ݂̉ʃ[hgp
	d3dpp.BackBufferFormat = d3ddm.Format;
	d3dpp.MultiSampleType = D3DMULTISAMPLE_NONE;
	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	d3dpp.hDeviceWindow = hFlWnd;
	// Zobt@Ƃ͂Ȃ
	d3dpp.EnableAutoDepthStencil = FALSE;
	// ͑҂Ȃ
	d3dpp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

	// foCX̍쐬͈xA2ڈȍ~͒ǉXbv`FC쐬
	if(g_lpD3DDEV == NULL  && argMode) {
		// foCX쐬2񎎍s
		for(int i = 0; i < 1; i++) {
			// foCX̍쐬 - T&L HAL
			if(FAILED(g_lpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hFlWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &g_lpD3DDEV))) {
				// ŝ HAL Ŏs
				if(FAILED(g_lpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hFlWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &g_lpD3DDEV))) {
					// ŝ REF Ŏs
					if(FAILED(g_lpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, hFlWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &g_lpD3DDEV))) {
						// ǎs
						MessageBox(hFlWnd, "Direct3D ̏Ɏs܂B", "FK_D3D", MB_OK | MB_ICONSTOP);
						return false;
					}
				}
			}
		}
	} else if(g_lpD3DDEV != NULL && !argMode) {
		g_lpD3DDEV->Release();
		g_lpD3DDEV = NULL;
		g_lpD3D->Release();
		g_lpD3D = NULL;
	}

	return true;
}
*/

// [h`FbN
bool CFullscreenControler::isFullscreen()
{
	return mode;
}

// tXN[
bool CFullscreenControler::changeToFullscreen()
{
	if(mode == false) {
		// EBhETCYۑ
		SaveWindowPosition();
		nWndX = pFlWnd->x();	nWndY = pFlWnd->y();
		nWndW = pFkWnd->w();	nWndH = pFkWnd->h();
		// 𑜓xύX
		pFlWnd->fullscreen();	// Fl_Window̃tXN[(xo[)
		if(ChangeScreen(hFlWnd, SCMODE_FULLSCREEN, nWndW, nWndH) == TRUE) {
			pFlWnd->resize(0, 0, fscW, fscH);	// TCY
			pFlWnd->color(FL_BLACK);
			pFkWnd->resizeWindow((fscW-nWndW)/2, (fscH-nWndH)/2, nWndW, nWndH);
			mode = true;

			return true;
		} else {
			pFlWnd->fullscreen_off(nWndX, nWndY, nWndW, nWndH);
			LoadWindowPosition();
			MessageBox(hFlWnd, "̊ł̓tXN[ł܂łB\n"
				"ʂ̃vpeBmF邩AEBhE[hŃvCĂB", "tXN[s", 0);

			return false;
		}
	} else {
		return true;
	}

}

// EBhE
void CFullscreenControler::changeToWindow()
{
	if(mode == true) {
		pFlWnd->fullscreen_off(nWndX, nWndY, nWndW, nWndH);
		pFkWnd->resizeWindow(0, 0, nWndW, nWndH);
		ChangeScreen(hFlWnd, SCMODE_WINDOW, nWndW, nWndH);
		LoadWindowPosition();

		mode = false;
	}

	return;
}
