#ifndef __FKA_FILE_INFO_HEADER__
#define __FKA_FILE_INFO_HEADER__

#include <fka/fka_ArchiveBase.h>
#include <string>

class fka_FileData;

class fka_FileInfo : public fka_Base {
 private:
	std::string			name;
	fka_uint			rawSize;
	fka_uint			bufSize;

 public:
	fka_FileInfo(void);
	~fka_FileInfo();

	void				init(void);

	void				setName(const std::string &);
	void				setRawSize(fka_uint);
	void				setBufferSize(fka_uint);

	std::string			getName(void);
	fka_uint			getRawSize(void);
	fka_uint			getBufferSize(void);

	void				readFileInfo(fka_FileData *);
	fka_uint			readInfoBuffer(fka_buffer *, fka_uint);
	void				pushBuffer(fka_buffer *);
};


#endif // !__FKA_FILE_INFO_HEADER__
