#ifndef __FKA_FILE_DATA_HEADER__
#define __FKA_FILE_DATA_HEADER__

#include <fka/fka_FileInfo.h>

class fka_FileData : public fka_Base {
 private:
	fka_buffer		buffer;
	fka_FileInfo	info;

 public:
	fka_FileData(void);	
	~fka_FileData();

	void			pushUInt(fka_uint);
	fka_uint		getUInt(fka_uint);
	fka_uchar		getUChar(fka_uint);

	void			init(void);
	void			setDataName(const std::string &);
	std::string		getDataName(void);

	void			setBuffer(fka_uchar *, fka_uint);
	fka_buffer *	getBuffer(void);
	fka_uchar *		getBuffer(fka_uint);
	fka_uint		getRawSize(void);

	bool			readFile(const std::string &);
	bool			readFile(const std::string &, fka_uint, fka_uint);
	bool			writeFile(const std::string &);

	bool			compress(void);
	bool			uncompress(void);
	bool			encrypt(void);
	bool			decrypt(void);
};

#endif // !__FKA_FILE_DATA_HEADER__
