#ifndef __FKA_ARCHIVE_OUT_HEADER__
#define __FKA_ARCHIVE_OUT_HEADER__

#include <fka/fka_ArchiveData.h>

class fka_ArchiveOut {
 private:

	std::vector<std::string>	fileArray;
	std::vector<std::string>	dataNameArray;
	fka_Archive_Mode			mode;

	int							FindFile(const std::string &);
	int							FindData(const std::string &);

public:
	fka_ArchiveOut(void);
	~fka_ArchiveOut();

	void				init(void);

	void				setMode(int);
	fka_Archive_Mode	getMode(void);

	int					getDataNum(void);
	std::string			getFileName(int);
	std::string			getDataName(int);

	bool				addFile(const std::string &);
	bool				replaceDataName(const std::string &,
										const std::string &);
	bool				deleteFile(const std::string &);

	bool				isExist(const std::string &);

	bool				writeArchive(const std::string &,
									 const std::string &);
};

#endif // !__FKA_ARCHIVE_OUT_HEADER__
