#ifndef __FKA_ARCHIVE_INFO_HEADER__
#define __FKA_ARCHIVE_INFO_HEADER__

#include <fka/fka_FileData.h>

class fka_ArchiveInfo : public fka_Base {

 private:

	std::vector<fka_FileInfo>	infoArray;
	fka_uint					dataSize, bufferSize;
	int							mode;

	void						makeCheckSum(fka_buffer *);
	void						setHeader(fka_buffer *, int);

 public:
	fka_ArchiveInfo(void);
	~fka_ArchiveInfo(void);

	void						init(void);
	void						pushInfo(fka_FileData *);
	int							find(const std::string &);
	fka_uint					getFileNum(void);
	fka_FileInfo *				getFileInfo(fka_uint);

	bool						readFile(FILE *, const std::string &);
	bool						writeFile(FILE *, int);

	fka_uint					getInfoBufSize(void);
	int							getMode(void);
};

#endif // !__FKA_ARCHIVE_INFO_HEADER__
