#ifndef __FKA_ARCHIVE_IN_HEADER__
#define __FKA_ARCHIVE_IN_HEADER__

#include <fka/fka_ArchiveData.h>

class fka_ArchiveIn {
 private:

	std::string			key;
	fka_ArchiveData		archiveData;
	bool				realMode;

	bool				ExtractData(int, fka_FileData *);
	bool				GetRealFileData(const std::string &, fka_buffer *);

public:
	fka_ArchiveIn(void);
	~fka_ArchiveIn();

	void				init(void);
	std::string			getArchiveName(void);
	std::string			getKey(void);
	void				setRealFileMode(bool);
	bool				getRealFileMode(void);

	int					getMode(const std::string &);
	bool				readArchive(const std::string &,
									const std::string & = "");

	bool				isExist(const std::string &);
	bool				getData(const std::string &, fka_buffer *);
	bool				extractFile(const std::string &,
									const std::string & = "");

	int					getDataNum(void);
	std::string			getDataName(int);
};

#endif // !__FKA_ARCHIVE_IN_HEADER__
