#ifndef __FKA_ARCHIVE_DATA_HEADER__
#define __FKA_ARCHIVE_DATA_HEADER__

#include <fka/fka_ArchiveInfo.h>

class fka_ArchiveData : public fka_Base {
 private:
	std::string		name;
	fka_ArchiveInfo	info;
	fka_buffer		dataBuf;

 public:
	fka_ArchiveData(void);	
	~fka_ArchiveData();

	void			pushInfo(fka_FileData *);
	void			pushData(fka_FileData *);

	void			init(void);
	void			setName(const std::string &);
	std::string		getName(void);

	int				find(const std::string &);
	bool			writeFile(int);
	bool			readFile(const std::string &);

	fka_uint		getFileNum(void);
	fka_FileInfo *	getFileInfo(fka_uint);

	fka_uint		getOffset(int);
	int				getMode(void);
};

#endif // !__FKA_ARCHIVE_DATA_HEADER__
