#ifndef __FKA_ARCHIVE_BASE_HEADER__
#define __FKA_ARCHIVE_BASE_HEADER__

#include <vector>

typedef unsigned long	fka_ulong;
typedef unsigned int	fka_uint;
typedef unsigned short	fka_ushort;
typedef unsigned char	fka_uchar;

const fka_uint	FKA_ARC_BUFSIZE		= 65536;
const int		FKA_ARC_NPASS		= 16;
const fka_uint	FKA_ARC_MASK		= 1920982;

typedef std::vector<fka_uchar>	fka_buffer;

enum fka_Archive_Mode {
	FKA_ARC_NONE =		0x00,
	FKA_ARC_RAW =		0x01,
	FKA_ARC_CRYPT =		0x02,
	FKA_ARC_COMPRESS =	0x04,
	FKA_ARC_FAIL =		0xff
};

#ifdef _MACOSX_PPC_

union fka_aword {
	fka_ulong	dword;
	fka_uchar	byte[4];
	struct {
		fka_uint		byte0:8;
		fka_uint		byte1:8;
		fka_uint		byte2:8;
		fka_uint		byte3:8;
	} w;
};

#else

union fka_aword {
	fka_ulong	dword;
	fka_uchar	byte[4];
	struct {
		fka_uint		byte3:8;
		fka_uint		byte2:8;
		fka_uint		byte1:8;
		fka_uint		byte0:8;
	} w;
};

#endif // _MACOSX_PPC_

class fka_Base {
 public:
	void		set_UInt(fka_uint, fka_uchar *);
	fka_uint	get_UInt(fka_uchar *);
};


#endif // !__FKA_ARCHIVE_BASE_HEADER__
