#include <fka/fka_FileInfo.h>
#include <fka/fka_FileData.h>

using namespace std;

fka_FileInfo::fka_FileInfo(void)
{
	init();
	return;
}

fka_FileInfo::~fka_FileInfo()
{
	return;
}

void fka_FileInfo::init(void)
{
	name.clear();
	rawSize = bufSize = 0;
	return;
}

void fka_FileInfo::setName(const string &argName)
{
	string::size_type	rep;

	name = argName;

	while((rep = name.find("\\")) != string::npos) {
		name.replace(rep, 1, "/");
	}

	return;
}

void fka_FileInfo::setRawSize(fka_uint argSize)
{
	rawSize = argSize;
	return;
}

void fka_FileInfo::setBufferSize(fka_uint argSize)
{
	bufSize = argSize;
	return;
}

string fka_FileInfo::getName(void)
{
	return name;
}

fka_uint fka_FileInfo::getRawSize(void)
{
	return rawSize;
}

fka_uint fka_FileInfo::getBufferSize(void)
{
	return bufSize;
}


void fka_FileInfo::readFileInfo(fka_FileData *argData)
{
	if(argData == NULL) return;
	init();

	name = argData->getDataName();
	rawSize = argData->getRawSize();
	bufSize = argData->getBuffer()->size();

	return;
}

void fka_FileInfo::pushBuffer(fka_buffer *argBuffer)
{
	fka_uint		tab, i;
	fka_uchar		*p;

	if(argBuffer == NULL) return;

	tab = argBuffer->size();
	argBuffer->resize(argBuffer->size() + name.size() + 12);

	p = &(*argBuffer)[tab];

	set_UInt(name.size(), &p[0]);
	set_UInt(bufSize, &p[4]);
	set_UInt(rawSize, &p[8]);
	for(i = 0; i < name.size(); i++) p[i+12] = name[i];

	return;
}

fka_uint fka_FileInfo::readInfoBuffer(fka_buffer *argBuffer, fka_uint argTab)
{
	fka_uint		i, nameSize;
	fka_uchar		*p = &(*argBuffer)[argTab];

	nameSize = get_UInt(p);
	name.resize(nameSize);
	bufSize = get_UInt(&p[4]);
	rawSize = get_UInt(&p[8]);
	for(i = 0; i < nameSize; i++) name[i] = p[i+12];

	return (argTab + 12 + nameSize);
}
