#include <fka/fka_FileData.h>
#include <fka/fka_BlowFish.h>
#include <iostream>
#include <stdio.h>
#include <zlib.h>

using namespace std;

fka_FileData::fka_FileData(void)
{
	init();
	return;
}

fka_FileData::~fka_FileData()
{
	return;
}

void fka_FileData::pushUInt(fka_uint argValue)
{
	fka_uint		tab;

	tab = buffer.size();
	buffer.resize(tab + 4);
	set_UInt(argValue, &buffer[tab]);
	return;
}

fka_uint fka_FileData::getUInt(fka_uint argTab)
{
	if(argTab < 0 || argTab > buffer.size() - 4) return 0;
	return get_UInt(&buffer[argTab]);
}

fka_uchar fka_FileData::getUChar(fka_uint argTab)
{
	if(argTab < 0 || argTab >= buffer.size()) return 0;
	return buffer[argTab];
}

void fka_FileData::init(void)
{
	buffer.clear();
	info.init();

	return;
}

void fka_FileData::setDataName(const string &argName)
{
	info.setName(argName);
	return;
}

string fka_FileData::getDataName(void)
{
	return info.getName();
}

void fka_FileData::setBuffer(fka_uchar *argBuffer, fka_uint argSize)
{
	buffer.resize(argSize);
	for(fka_uint i = 0; i < argSize; i++) buffer[i] = argBuffer[i];
	info.setRawSize(buffer.size());
	info.setBufferSize(buffer.size());
	return;
}

fka_buffer * fka_FileData::getBuffer(void)
{
	return &buffer;
}

fka_uchar * fka_FileData::getBuffer(fka_uint argTab)
{
	if(argTab < 0 || argTab >= buffer.size()) return NULL;
	return &buffer[argTab];
}

fka_uint fka_FileData::getRawSize(void)
{
	return info.getRawSize();
}

bool fka_FileData::readFile(const string &argFileName)
{
	fka_buffer	inBuf;
	size_t		size;
	FILE		*fp;
	fka_uint	i;

	if((fp = fopen(argFileName.c_str(), "rb")) == NULL) {
		return false;
	}

	buffer.clear();
	inBuf.resize(FKA_ARC_BUFSIZE);
	while((size = fread(&inBuf[0], sizeof(fka_uchar),
						FKA_ARC_BUFSIZE, fp)) == FKA_ARC_BUFSIZE) {
		for(i = 0; i < inBuf.size(); i++) buffer.push_back(inBuf[i]);
	}
	fclose(fp);

	inBuf.resize(size);
	for(i = 0; i < inBuf.size(); i++) buffer.push_back(inBuf[i]);
	info.setRawSize(buffer.size());
	info.setBufferSize(buffer.size());

	return true;
}

bool fka_FileData::readFile(const string &argFileName,
							fka_uint argTab, fka_uint argSize)
{
	fka_buffer	inBuf;
	size_t		size, remainSize;
	FILE		*fp;
	fka_uint	i;

	if((fp = fopen(argFileName.c_str(), "rb")) == NULL) {
		return false;
	}

	if(fseek(fp, long(argTab), SEEK_SET) != 0) {
		fclose(fp);
		return false;
	}

	buffer.clear();
	inBuf.resize(FKA_ARC_BUFSIZE);

	remainSize = argSize;

	while(remainSize > FKA_ARC_BUFSIZE) {
		if((size = fread(&inBuf[0], sizeof(fka_uchar),
						 FKA_ARC_BUFSIZE, fp)) != FKA_ARC_BUFSIZE) {
			fclose(fp);
			buffer.clear();
			return false;
		}
		for(i = 0; i < inBuf.size(); i++) buffer.push_back(inBuf[i]);
		remainSize -= FKA_ARC_BUFSIZE;
	}

	if(fread(&inBuf[0], sizeof(fka_uchar), remainSize, fp) != remainSize) {
		fclose(fp);
		buffer.clear();
		return false;
	}

	fclose(fp);

	inBuf.resize(remainSize);
	for(i = 0; i < inBuf.size(); i++) buffer.push_back(inBuf[i]);
	info.setRawSize(buffer.size());
	info.setBufferSize(buffer.size());

	return true;
}

bool fka_FileData::writeFile(const string &argFileName)
{
	FILE		*fp;

	if((fp = fopen(argFileName.c_str(), "wb")) == NULL) return false;

	if(fwrite(&buffer[0], sizeof(fka_uchar),
			  buffer.size(), fp) != buffer.size()) {
		return false;
	}
	fclose(fp);

	return true;
}

bool fka_FileData::compress(void)
{
	vector<fka_uchar>	outBuf;
	z_stream			zStream;
	int					zFlush, zStatus;

	zStream.zalloc = Z_NULL;
	zStream.zfree = Z_NULL;
	zStream.opaque = Z_NULL;

	if(deflateInit(&zStream, Z_DEFAULT_COMPRESSION) != Z_OK) {
		return false;
	}

	outBuf.resize(FKA_ARC_BUFSIZE);
	zStream.next_in = &buffer[0];
	zStream.avail_in = sizeof(fka_uchar) * buffer.size();
	zStream.next_out = &outBuf[0];
	zStream.avail_out = sizeof(fka_uchar) * FKA_ARC_BUFSIZE;

	zFlush = Z_NO_FLUSH;
	while(true) {
		if(zStream.avail_in < FKA_ARC_BUFSIZE) zFlush = Z_FINISH;
		zStatus = deflate(&zStream, zFlush);

		if(zStatus == Z_STREAM_END) break;
		if(zStatus != Z_OK) {
			return false;
		}

		if(zStream.avail_out == 0) {
			outBuf.resize(outBuf.size() + FKA_ARC_BUFSIZE);
			zStream.next_out = &outBuf[outBuf.size() - FKA_ARC_BUFSIZE];
			zStream.avail_out = sizeof(fka_uchar) * FKA_ARC_BUFSIZE;
		}
	}

	outBuf.resize(outBuf.size() - zStream.avail_out);

	if(deflateEnd(&zStream) != Z_OK) {
		return false;
	}

	if(buffer.size() <= outBuf.size()) {
		return true;
	}

	buffer.resize(outBuf.size());
	for(fka_uint i = 0; i < buffer.size(); i++) buffer[i] = outBuf[i];
	info.setBufferSize(buffer.size());

	return true;
}

bool fka_FileData::uncompress(void)
{
	vector<fka_uchar>	outBuf;
	z_stream			zStream;
	int					zStatus;

	zStream.zalloc = Z_NULL;
	zStream.zfree = Z_NULL;
	zStream.opaque = Z_NULL;

	zStream.next_in = Z_NULL;
	zStream.avail_in = 0;

	if(inflateInit(&zStream) != Z_OK) {
		return false;
	}

	outBuf.resize(FKA_ARC_BUFSIZE);
	zStream.next_in = &buffer[0];
	zStream.avail_in = sizeof(fka_uchar) * buffer.size();
	zStream.next_out = &outBuf[0];
	zStream.avail_out = sizeof(fka_uchar) * FKA_ARC_BUFSIZE;
	zStatus = Z_OK;

	while(true) {
		zStatus = inflate(&zStream, Z_NO_FLUSH);
		if(zStatus == Z_STREAM_END) break;
		if(zStatus != Z_OK) {
			return false;
		}

		if(zStream.avail_out == 0) {
			outBuf.resize(outBuf.size() + FKA_ARC_BUFSIZE);
			zStream.next_out = &outBuf[outBuf.size() - FKA_ARC_BUFSIZE];
			zStream.avail_out = sizeof(fka_uchar) * FKA_ARC_BUFSIZE;
		}
	}

	outBuf.resize(outBuf.size() - zStream.avail_out);

	if(inflateEnd(&zStream) != Z_OK) {
		return false;
	}

	buffer.resize(outBuf.size());
	for(fka_uint i = 0; i < buffer.size(); i++) buffer[i] = outBuf[i];

	info.setRawSize(buffer.size());
	info.setBufferSize(buffer.size());

	return true;
}

bool fka_FileData::encrypt(void)
{
	fka_uint		i, bufSize;

	bufSize = buffer.size();

	buffer.resize(fka_BlowFish::round(buffer.size()) + 8);
	for(i = buffer.size() - 1; i >= 8; i--) buffer[i] = buffer[i-8];

	set_UInt(FKA_ARC_MASK, &buffer[0]);
	set_UInt(bufSize, &buffer[4]);

	fka_BlowFish::encrypt(&buffer[0], buffer.size());
	info.setBufferSize(buffer.size());

	return true;
}

bool fka_FileData::decrypt(void)
{
	fka_uint		i, size, mask;
	fka_buffer		tmpBuffer;

	if(buffer.size() < 8) return false;

	tmpBuffer.resize(8);
	for(i = 0; i < 8; i++) tmpBuffer[i] = buffer[i];

	fka_BlowFish::decrypt(&tmpBuffer[0], 8);

	mask = get_UInt(&tmpBuffer[0]);

	if(mask != FKA_ARC_MASK) return false;
	size = get_UInt(&tmpBuffer[4]);

	if(buffer.size() != fka_BlowFish::round(size) + 8) return false;
	buffer.erase(buffer.begin(), buffer.begin()+8);

	fka_BlowFish::decrypt(&buffer[0], buffer.size());
	buffer.resize(size);
	info.setBufferSize(size);

	return true;
}

