#include <fka/fka_BlowFish.h>
#include <fka/fka_BlowFishNumTable.h>

static fka_ulong	pArray[FKA_ARC_NPASS + 2];
static fka_ulong	sBoxes[1024];

fka_BlowFish::fka_BlowFish(void)
{
	return;
}

fka_BlowFish::~fka_BlowFish()
{
	return;
}

fka_ulong fka_BlowFish::bf_shift(fka_aword &x, int i)
{
	switch(i) {
	  case 0:
		return sBoxes[x.w.byte0];
	  case 1:
		return sBoxes[x.w.byte1 + 256];
	  case 2:
		return sBoxes[x.w.byte2 + 512];
	  case 3:
		return sBoxes[x.w.byte3 + 768];
	  default:
		break;
	}

	return 0;
}

fka_ulong fka_BlowFish::bf_func(fka_aword &x)
{
	fka_ulong	ret;

	ret = ((bf_shift(x, 0) + bf_shift(x, 1)) ^ bf_shift(x, 2)) + bf_shift(x, 3);
	return ret;
}

void fka_BlowFish::round(fka_aword *a, fka_aword &b, int n)
{
	a->dword ^= bf_func(b) ^ pArray[n];
	return;
}

void fka_BlowFish::Char2Long(fka_uchar *argChar, fka_ulong *argLong)
{
	fka_aword	word;

	word.w.byte0 = argChar[0];
	word.w.byte1 = argChar[1];
	word.w.byte2 = argChar[2];
	word.w.byte3 = argChar[3];

	*argLong = word.dword;
	return;
}

void fka_BlowFish::Long2Char(fka_ulong *argLong, fka_uchar *argChar)
{
	fka_aword	word;

	word.dword = *argLong;
	argChar[0] = word.w.byte0;
	argChar[1] = word.w.byte1;
	argChar[2] = word.w.byte2;
	argChar[3] = word.w.byte3;

	return;
}

void fka_BlowFish::Encipher_Char(fka_uchar *argL, fka_uchar *argR)
{
	fka_ulong		dataL, dataR;

	Char2Long(argL, &dataL);
	Char2Long(argR, &dataR);
	BlowFish_encipher(&dataL, &dataR);
	Long2Char(&dataL, argL);
	Long2Char(&dataR, argR);

	return;
}

void fka_BlowFish::Decipher_Char(fka_uchar *argL, fka_uchar *argR)
{
	fka_ulong		dataL, dataR;

	Char2Long(argL, &dataL);
	Char2Long(argR, &dataR);
	BlowFish_decipher(&dataL, &dataR);
	Long2Char(&dataL, argL);
	Long2Char(&dataR, argR);

	return;
}

void fka_BlowFish::BlowFish_encipher(fka_ulong *argXL, fka_ulong *argXR)
{
	union fka_aword		xL, xR;
	int					i;

	xL.dword = *argXL;
	xR.dword = *argXR;

	xL.dword ^= pArray[0];

	for(i = 1; i < 16; i += 2) {
		round(&xR, xL, i);
		round(&xL, xR, i+1);
	}

	xR.dword ^= pArray [17] ;

	*argXR = xL.dword ;
	*argXL = xR.dword ;
}

void fka_BlowFish::BlowFish_decipher(fka_ulong *argXL, fka_ulong *argXR)
{
	union fka_aword		xL, xR;
	int					i;

	xL.dword = *argXL;
	xR.dword = *argXR;

	xL.dword ^= pArray[17];

	for(i = 16; i >= 1; i -= 2) {
		round(&xR, xL, i);
		round(&xL, xR, i-1);
	}

	xR.dword ^= pArray[0];

	*argXL = xR.dword;
	*argXR = xL.dword;
}

void fka_BlowFish::init(fka_uchar *argKey, int argKeyBytes)
{
	int					i, j;
	fka_ulong			data, dataL, dataR;
	union fka_aword		tmp;

	for(i = 0; i < 18; i++) pArray[i] = fka_bf_P[i];
	for(i = 0; i < 1024; i++) sBoxes[i] = fka_bf_S[i];

	j = 0;
	tmp.dword = 0;
	dataL = 0;
	dataR = 0;

	for(i = 0; i < FKA_ARC_NPASS + 2; i++) {
		tmp.w.byte0 = argKey[j % argKeyBytes];
		tmp.w.byte1 = argKey[(j+1) % argKeyBytes];
		tmp.w.byte2 = argKey[(j+2) % argKeyBytes];
		tmp.w.byte3 = argKey[(j+3) % argKeyBytes];

		data = tmp.dword;
		pArray[i] ^= data;
		j += 4;
	}

	for(i = 0; i < FKA_ARC_NPASS + 2; i += 2) {
		BlowFish_encipher(&dataL, &dataR);
		pArray[i] = dataL;
		pArray[i+1] = dataR;
	}

	for(i = 0; i < 4*256; i += 2) {
		BlowFish_encipher(&dataL, &dataR);
		sBoxes[i] = dataL;
		sBoxes[i+1] = dataR;
	}

	return;
}

fka_ulong fka_BlowFish::round(fka_ulong argInput)
{
	fka_ulong	lVal = argInput % 8;

	if(lVal != 0) return (argInput + 8) - lVal;
	return argInput;
}

fka_ulong fka_BlowFish::encrypt(fka_uchar *argInput, fka_ulong argSize)
{
	fka_ulong	count, outSize;
	fka_uchar	*po;
	int			i, j;

	outSize = round(argSize);

	for(count = 0; count < outSize; count += 8) {
		if(count < argSize - 7) {
			Encipher_Char(argInput, argInput + 4);
		} else {
			po = argInput + argSize;
			j = int(outSize - argSize);
			for(i = 0; i < j; i++) *po++ = 0;
			Encipher_Char(argInput, argInput + 4);
		}
		argInput += 8;
	}

	return outSize;
}

void fka_BlowFish::decrypt(fka_uchar *argInput, fka_ulong argSize)
{
	fka_ulong	count;

	for(count = 0; count < argSize; count += 8) {
		Decipher_Char(argInput, argInput + 4);
		argInput += 8;
	}
	return;
}
