#include <fka/fka_ArchiveOut.h>
#include <fka/fka_BlowFish.h>

using namespace std;

fka_ArchiveOut::fka_ArchiveOut(void)
{
	init();
	setMode(FKA_ARC_RAW);
	return;
}

fka_ArchiveOut::~fka_ArchiveOut()
{
	init();
	return;
}

void fka_ArchiveOut::init(void)
{
	fileArray.clear();
	dataNameArray.clear();
	mode = FKA_ARC_NONE;

	return;
}

int fka_ArchiveOut::FindFile(const string &argFileName)
{
	for(int i = 0; i < int(fileArray.size()); i++) {
		if(fileArray[i] == argFileName) return i;
	}

	return -1;
}

int fka_ArchiveOut::FindData(const string &argDataName)
{
	for(int i = 0; i < int(dataNameArray.size()); i++) {
		if(dataNameArray[i] == argDataName) return i;
	}

	return -1;
}

void fka_ArchiveOut::setMode(int argMode)
{
	mode = fka_Archive_Mode(argMode);
	return;
}

fka_Archive_Mode fka_ArchiveOut::getMode(void)
{
	return mode;
}

int fka_ArchiveOut::getDataNum(void)
{
	return int(fileArray.size());
}

string fka_ArchiveOut::getFileName(int argID)
{
	if(argID < 0 || argID >= int(fileArray.size())) return "";
	return fileArray[argID];
}

string fka_ArchiveOut::getDataName(int argID)
{
	if(argID < 0 || argID >= int(fileArray.size())) return "";
	return dataNameArray[argID];
}

bool fka_ArchiveOut::addFile(const string &argFileName)
{
	if(FindFile(argFileName) != -1) return false;

	fileArray.push_back(argFileName);
	dataNameArray.push_back(argFileName);
	return true;
}

bool fka_ArchiveOut::isExist(const string &argFileName)
{
	if(FindFile(argFileName) == -1) return false;
	return true;
}

bool fka_ArchiveOut::replaceDataName(const string &argFileName,
									 const string &argDataName)
{
	int		index = FindFile(argFileName);

	if(index == -1) return false;
	dataNameArray[index] = argDataName;
	return true;
}

bool fka_ArchiveOut::deleteFile(const string &argFileName)
{
	int		index = FindFile(argFileName);

	if(index == -1) return false;
	fileArray.erase(fileArray.begin()+index);
	dataNameArray.erase(dataNameArray.begin()+index);
	return true;
}


bool fka_ArchiveOut::writeArchive(const string &argArchiveName,
								  const string &argKey)
{
	fka_ArchiveData		aData;
	fka_FileData		fData;

	aData.setName(argArchiveName);

	if((mode & FKA_ARC_CRYPT) == FKA_ARC_CRYPT) {
		fka_BlowFish::init((fka_uchar *)argKey.c_str(), argKey.size());
	}

	for(fka_uint i = 0; i < fileArray.size(); i++) {
		fData.init();
		if(fData.readFile(fileArray[i]) == true) {
			fData.setDataName(dataNameArray[i]);

			if((mode & FKA_ARC_COMPRESS) == FKA_ARC_COMPRESS) {
				fData.compress();
			}

			if((mode & FKA_ARC_CRYPT) == FKA_ARC_CRYPT) {
				fData.encrypt();
			}

			aData.pushInfo(&fData);
			aData.pushData(&fData);
		}
	}

	return aData.writeFile(mode);
}
