#include <fka/fka_ArchiveInfo.h>
#include <fka/fka_BlowFish.h>
#include <iostream>
#include <algorithm>
#include <time.h>

using namespace std;

fka_ArchiveInfo::fka_ArchiveInfo(void)
{
	init();
	return;
}

fka_ArchiveInfo::~fka_ArchiveInfo()
{
	return;
}

void fka_ArchiveInfo::init(void)
{
	infoArray.clear();
	dataSize = bufferSize = 0;
	return;
}

void fka_ArchiveInfo::makeCheckSum(fka_buffer *argBuf)
{
	fka_uint	check[5], loopNum, i;
	fka_uchar	*p;

	srand(time(0));
	loopNum = rand() % 1024;
	for(i = 0; i < 1024 + loopNum; i++) rand();
	check[0] = rand() % 0x0fffffff;
	check[1] = rand() % 0x0fffffff;
	check[2] = check[0] + check[1];
	check[3] = check[2] + 1;

	argBuf->resize(32);
	p = &(*argBuf)[0];

	for(i = 0; i < 4; i++) set_UInt(check[i], &p[(i+2)*4]);
	return;
}

void fka_ArchiveInfo::setHeader(fka_buffer *argBuf, int argMode)
{
	fka_uchar		*p = &(*argBuf)[0];

	set_UInt(fka_uint(FKA_ARC_MASK), &p[0]);
	set_UInt(fka_uint(argMode), &p[4]);
	set_UInt(infoArray.size(), &p[24]);
	set_UInt(argBuf->size() - 32, &p[28]);
	return;
}

void fka_ArchiveInfo::pushInfo(fka_FileData *argFileData)
{
	if(argFileData == NULL) return;

	infoArray.resize(infoArray.size()+1);
	infoArray[infoArray.size()-1].readFileInfo(argFileData);

	return;
}

bool fka_ArchiveInfo::readFile(FILE *argFP, const string &argKey)
{
	fka_uint	i, infoNum, check[4], tab;
	fka_buffer	infoBuf;

	if(argFP == NULL) return false;

	infoBuf.resize(32);

	if(fread(&infoBuf[0], sizeof(fka_uchar), 32, argFP) != 32) return false;

	if(get_UInt(&infoBuf[0]) != FKA_ARC_MASK) return false;
	mode = get_UInt(&infoBuf[4]);

	if((mode & FKA_ARC_CRYPT) == FKA_ARC_CRYPT) {
		fka_BlowFish::init((fka_uchar *)argKey.c_str(), argKey.size());
		fka_BlowFish::decrypt(&infoBuf[8], 24);
	}

	for(i = 0; i < 4; i++) check[i] = get_UInt(&infoBuf[(i+2)*4]);
	if(check[0] + check[1] != check[2] || check[2] + 1 != check[3]) {
		return false;
	}

	infoNum = get_UInt(&infoBuf[24]);
	dataSize = get_UInt(&infoBuf[28]);

	if((mode & FKA_ARC_CRYPT) == FKA_ARC_CRYPT) {
		bufferSize = fka_BlowFish::round(dataSize);
	} else {
		bufferSize = dataSize;
	}

	infoArray.resize(infoNum);
	infoBuf.resize(bufferSize);

	if(fread(&infoBuf[0], sizeof(fka_uchar),
			 bufferSize, argFP) != bufferSize) {
		return false;
	}

	if((mode & FKA_ARC_CRYPT) == FKA_ARC_CRYPT) {
		fka_BlowFish::decrypt(&infoBuf[0], bufferSize);
		infoBuf.resize(dataSize);
	}

	tab = 0;

	for(i = 0; i < infoNum; i++) {
		tab = infoArray[i].readInfoBuffer(&infoBuf, tab);
	}

	//for(i = 0; i < infoNum; i++) infoArray[i].print();

	return true;
}

bool fka_ArchiveInfo::writeFile(FILE *argFP, int argMode)
{
	fka_buffer		infoBuf;

	if(argFP == NULL) return false;
	infoBuf.clear();
	makeCheckSum(&infoBuf);

	for(fka_uint i = 0; i < infoArray.size(); i++) {
		infoArray[i].pushBuffer(&infoBuf);
	}

	setHeader(&infoBuf, argMode);

	if((argMode & FKA_ARC_CRYPT) == FKA_ARC_CRYPT) {
		infoBuf.resize(fka_BlowFish::round(infoBuf.size()));
		fka_BlowFish::encrypt(&infoBuf[8], infoBuf.size() - 8);
	}

	if(fwrite(&infoBuf[0], sizeof(fka_uchar),
			  infoBuf.size(), argFP) != infoBuf.size()) return false;

	return true;
}

int fka_ArchiveInfo::find(const string &argName)
{
	string					name = argName, tmpName;
	string::size_type		rep;
	int						i;

	while((rep = name.find("\\")) != string::npos) {
		name.replace(rep, 1, "/");
	}

	// ToLower
	transform(name.begin(), name.end(), name.begin(), tolower);

	for(i = 0; i < int(infoArray.size()); i++) {
		tmpName = infoArray[i].getName();
		transform(tmpName.begin(), tmpName.end(), tmpName.begin(), tolower);
		if(name == tmpName) return i;
	}

	return -1;
}

fka_uint fka_ArchiveInfo::getFileNum(void)
{
	return infoArray.size();
}

fka_FileInfo * fka_ArchiveInfo::getFileInfo(fka_uint argIndex)
{
	if(argIndex >= infoArray.size()) return NULL;
	return &infoArray[argIndex];
}

fka_uint fka_ArchiveInfo::getInfoBufSize(void)
{
	return (bufferSize+32);
}

int fka_ArchiveInfo::getMode(void)
{
	return mode;
}
