#include <fka/fka_ArchiveIn.h>
#include <fka/fka_BlowFish.h>
#include <iostream>

using namespace std;

fka_ArchiveIn::fka_ArchiveIn(void)
{
	init();
	return;
}

fka_ArchiveIn::~fka_ArchiveIn()
{
	return;
}

void fka_ArchiveIn::init(void)
{
	key.clear();
	archiveData.init();
	realMode = true;
	return;
}

void fka_ArchiveIn::setRealFileMode(bool argMode)
{
	realMode = argMode;
	return;
}

bool fka_ArchiveIn::getRealFileMode(void)
{
	return realMode;
}

bool fka_ArchiveIn::readArchive(const string &argFileName,
								const string &argKey)
{
	key = argKey;
	archiveData.setName(argFileName);
	return archiveData.readFile(key);
}

bool fka_ArchiveIn::isExist(const string &argFileName)
{
	if(archiveData.find(argFileName) < 0) return false;
	return true;
}

bool fka_ArchiveIn::ExtractData(int argIndex, fka_FileData *argFileData)
{
	int					mode;
	fka_FileInfo		*info;
	fka_uint			tab, size;

	info = archiveData.getFileInfo(fka_uint(argIndex));
	tab = archiveData.getOffset(argIndex);
	size = info->getBufferSize();
	mode = archiveData.getMode();

	argFileData->init();

	if(argFileData->readFile(archiveData.getName(), tab, size) == false) {
		return false;
	}

	if((mode & FKA_ARC_CRYPT) == FKA_ARC_CRYPT) {
		argFileData->decrypt();
	}

	if((mode & FKA_ARC_COMPRESS) == FKA_ARC_COMPRESS &&
	   info->getRawSize() != argFileData->getBuffer()->size()) {
		argFileData->uncompress();
	}

	return true;
}

bool fka_ArchiveIn::getData(const string &argFileName, fka_buffer *argBuffer)
{
	fka_FileData		fileData;
	int					index;
	fka_uint			i;
	fka_buffer			*fileBuffer;

	if(argBuffer == NULL) return false;
	index = archiveData.find(argFileName);

	if(index < 0) {
		if(realMode == true) {
			return GetRealFileData(argFileName, argBuffer);
		} else {
			return false;
		}
	}

	if(ExtractData(index, &fileData) == false) return false;

	fileBuffer = fileData.getBuffer();
	argBuffer->resize(fileBuffer->size());
	for(i = 0; i < fileBuffer->size(); i++) {
		(*argBuffer)[i] = (*fileBuffer)[i];
	}

	return true;
}

bool fka_ArchiveIn::GetRealFileData(const string &argFileName,
									fka_buffer *argBuffer)
{
	fka_FileData		fileData;
	fka_buffer			*fileBuffer;

	if(fileData.readFile(argFileName) == false) return false;

	fileBuffer = fileData.getBuffer();
	argBuffer->resize(fileBuffer->size());
	for(fka_uint i = 0; i < fileBuffer->size(); i++) {
		(*argBuffer)[i] = (*fileBuffer)[i];
	}

	return true;
}

bool fka_ArchiveIn::extractFile(const string &argDataName,
								const string &argFileName)
{
	string				fileName;
	fka_FileData		fileData;
	int					index;

	index = archiveData.find(argDataName);
	if(index < 0) return false;

	if(argFileName.length() == 0) {
		fileName = argDataName;
	} else {
		fileName = argFileName;
	}

	if(ExtractData(index, &fileData) == false) return false;

	return fileData.writeFile(fileName);
}

int fka_ArchiveIn::getDataNum(void)
{
	return int(archiveData.getFileNum());
}

string fka_ArchiveIn::getDataName(int argIndex)
{
	if(argIndex < 0 || argIndex >= int(archiveData.getFileNum())) {
		return "";
	}

	return archiveData.getFileInfo(fka_uint(argIndex))->getName();
}

int fka_ArchiveIn::getMode(const string &argFileName)
{
	fka_FileData		fileData;

	fileData.init();
	if(fileData.readFile(argFileName, 0, 8) == false) return FKA_ARC_FAIL;
	if(fileData.getUInt(0) != FKA_ARC_MASK) return FKA_ARC_FAIL;
	return fileData.getUInt(4);
}
