#include <fka/fka_ArchiveData.h>

using namespace std;

fka_ArchiveData::fka_ArchiveData(void)
{
	init();
	return;
}

fka_ArchiveData::~fka_ArchiveData()
{
	return;
}

void fka_ArchiveData::pushInfo(fka_FileData *argData)
{
	info.pushInfo(argData);
	return;
}

void fka_ArchiveData::pushData(fka_FileData *argData)
{
	fka_buffer	*argDataBuf;
	fka_uint	bufferSize;
	fka_uint	tab, i;

	if(argData == NULL) return;
	argDataBuf = argData->getBuffer();
	bufferSize = argDataBuf->size();

	tab = dataBuf.size();
	dataBuf.resize(tab + bufferSize);

	for(i = 0; i < bufferSize; i++) {
		dataBuf[tab + i] = (*argDataBuf)[i];
	}

	return;
}

void fka_ArchiveData::init(void)
{
	name.clear();
	info.init();
	dataBuf.clear();

	return;
}

void fka_ArchiveData::setName(const string &argName)
{
	string::size_type	rep;

	name = argName;

	while((rep = name.find("\\")) != string::npos) {
		name.replace(rep, 1, "/");
	}

	return;
}

string fka_ArchiveData::getName(void)
{
	return name;
}

bool fka_ArchiveData::writeFile(int argMode)
{
	FILE		*fp;

	if((fp = fopen(name.c_str(), "wb")) == NULL) return false;

	if(info.writeFile(fp, argMode) == false) return false;

	if(fwrite(&dataBuf[0], sizeof(fka_uchar),
			  dataBuf.size(), fp) != dataBuf.size()) {
		return false;
	}
	fclose(fp);

	return true;
}

bool fka_ArchiveData::readFile(const string &argKey)
{
	FILE		*fp;

	if((fp = fopen(name.c_str(), "rb")) == NULL) return false;

	if(info.readFile(fp, argKey) == false) return false;
	fclose(fp);

	return true;
}

int fka_ArchiveData::find(const string &argName)
{
	return info.find(argName);
}

fka_uint fka_ArchiveData::getFileNum(void)
{
	return info.getFileNum();
}

fka_FileInfo * fka_ArchiveData::getFileInfo(fka_uint argIndex)
{
	return info.getFileInfo(argIndex);
}

fka_uint fka_ArchiveData::getOffset(int argIndex)
{
	fka_uint		total = 0;
	int				i;

	if(argIndex < 0 || argIndex >= int(getFileNum())) return 0;

	for(i = 0; i < argIndex; i++) {
		total += info.getFileInfo(i)->getBufferSize();
	}

	return (info.getInfoBufSize() + total);
}

int fka_ArchiveData::getMode(void)
{
	return info.getMode();
}
