#include "TransitionEffect.h"

TransitionEffect::TransitionEffect(void)
{
	block.setSize(100.0, 100.0, 1.0);
	effectModel.setShape(&block);
	effectMat.setAmbDiff(0.0, 0.0, 0.0);
	effectMat.setSpecular(0.0, 0.0, 0.0);
	effectMat.setEmission(0.0, 0.0, 0.0);
	effectMat.setAlpha(1.0);
	effectModel.setMaterial(effectMat);
	effectModel.glMoveTo(0.0, 0.0, -10.0);

	regTime = 0;
	useTime = 0;
	mode = 0;

	return;
}

TransitionEffect::~TransitionEffect(void)
{
}

void TransitionEffect::fadeFrom(double r, double g, double b, unsigned long t)
{
	mode = 1;
	effectMat.setEmission(r, g, b);
	effectMat.setAlpha(1.0);
	effectModel.setMaterial(effectMat);
	regTime = timeGetTime();
	useTime = t;

	return;
}

void TransitionEffect::fadeTo(double r, double g, double b, unsigned long t)
{
	mode = 2;
	effectMat.setEmission(r, g, b);
	effectMat.setAlpha(0.0);
	effectModel.setMaterial(effectMat);
	regTime = timeGetTime();
	useTime = t;

	return;
}

bool TransitionEffect::update(fk_Scene *scene)
{
	unsigned long nowTime = timeGetTime();
	double	alpha;

	switch(mode) {
	case 1:
		effectModel.setParent((fk_Model *)scene->getCamera());
		scene->entryOverlayModel(&effectModel);
		alpha = 1.0 - (double)(nowTime-regTime)/(double)useTime;
		if(alpha < 0.0) {
			mode = 0;
			effectMat.setAlpha(0.0);
			effectModel.setMaterial(effectMat);
			scene->removeOverlayModel(&effectModel);
			return false;
		} else {
			effectMat.setAlpha(alpha);
			effectModel.setMaterial(effectMat);
		}
		break;
	case 2:
		effectModel.setParent((fk_Model *)scene->getCamera());
		scene->entryOverlayModel(&effectModel);
		alpha = (double)(nowTime-regTime)/(double)useTime;
		if(alpha > 1.0) {
			mode = 0;
			effectMat.setAlpha(1.0);
			effectModel.setMaterial(effectMat);
			return false;
		} else {
			effectMat.setAlpha(alpha);
			effectModel.setMaterial(effectMat);
		}
		break;
	default:
		return false;
	}

	return true;
}

int TransitionEffect::getMode(void)
{
	return mode;
}
