#include "SceneOBB.h"


SceneOBB::SceneOBB(fk_Window *argWin, EventManager *argEve)
: SceneBase(argWin, argEve), tb(argWin, &camera), spr(1280, 720)
{
	// Ɩ̐ݒ
	lightModel.setShape(&light);
	lightModel.setMaterial(White);
	lightModel.getMaterial()->setAmbDiff(1.0, 1.0, 1.0);
	lightModel.glMoveTo(0.0, 0.0, 0.0);
	lightModel.glFocus(0.5, -1.0, 0.0);

	// effBXvCXgɓo^
	scene.entryCamera(&camera);
	scene.entryModel(&lightModel);
	// }bṽGg[
	map.entryScene(&scene);
	// vC[̃Gg[
	player.entryScene(&scene);

	// _̈ʒuƎpݒ
	camera.glMoveTo(0.0, 100.0, 100.0);
	camera.glFocus(0.0, 0.0, 0.0);
	camera.glUpvec(0.0, 1.0, 0.0);

	spr.initFont("C:\\Windows\\fonts\\Meiryo.ttc");
	spr.text.setBackColor(0.0f, 0.0f, 0.0f, 0.5f);
	spr.drawText("V[1");
	spr.setPositionLT(-480.0, 270.0);
	spr.entryFirst(&scene, &camera);

	// ꂾłi[vplayĂԕKvj
	bgm_th.load("bgm/stage_01.ogg");
}

SceneOBB::~SceneOBB(void)
{
	// NX̃fXgN^łn͂邯ǁAꉞ
	bgm_th.stop();
}

int	SceneOBB::onPeriod(void)
{
	fk_Vector	plSpd, plPos;

	// L[ɂXs[hύX
	player.update(&map, ref_event, &camera);

	plSpd = player.getSpd();
	plSpd.y = 0.0;
	camera.glTranslate(plSpd);

	plPos = player.getModel()->getPosition();
	plPos.y = 0.0;
	tb.setLookTo(plPos);

	tb.update();

	// V[Jڏ
	if(ref_event->getSpecialKeyStatus(FK_F2) == FKUT_SW_DOWN) {
		return SCENE_MOTION;
	}

	if(ref_event->getKeyStatus('1') == FKUT_SW_DOWN) {
		readTest();
	}
	if(ref_event->getKeyStatus('2') == FKUT_SW_DOWN) {
		writeTest();
	}

	if(ref_event->getKeyStatus('p') == FKUT_SW_DOWN) {
		bgm_th.play();
	}
	if(ref_event->getKeyStatus('q') == FKUT_SW_DOWN) {
		bgm_th.stop();
	}

	return 0;
}

//////////////////////////////////////////////////////////////
void SceneOBB::writeTest(void)
{
	fk_Vector	vec, dir;

	ofstream	out_file("output_test.txt");

	if(out_file.is_open() == false) {
		fl_alert("t@C݂Ɏs");
	} else {
		out_file << "OUTPUT\tTEST\t00" << endl;

		out_file << vec.x << "," << vec.y << "," << vec.z << endl;
		out_file << dir.x << "," << dir.y << "," << dir.z << endl;

		out_file << "[FINISH]" << endl;

		out_file.close();
	}
}
////////////////////////////////////////////////////////////////
void SceneOBB::readTest(void)
{
	ifstream		in_file("output_test.txt");

	string			lineStr;
	vector<string>	readBuffer, splitArray;
	fk_Vector		rec;
	
	if(in_file.is_open() == false) {
		fl_alert("t@C݂Ɏs");
	} else {
		while(getline(in_file, lineStr)) {
			cout << lineStr << endl;
			// ؂\Ă݂
			splitArray = fk_StrSplit(lineStr, ",");

			if(splitArray.size() <= 1) {
				cout << "Not Split" << endl;
			} else {
				cout << "Split Result:" << endl;
				for(int i = 0 ; i < (int)splitArray.size(); i++) {
					cout << splitArray[i] << endl;
				}
				rec.x = atof(splitArray[0].c_str());
				rec.y = atof(splitArray[1].c_str());
				rec.z = atof(splitArray[2].c_str());
			}

			readBuffer.push_back(lineStr);
		}

		in_file.close();
	}
}