#include "SceneMC.h"

SceneMC::SceneMC(fk_Window *argWin, EventManager *argEve)
: SceneBase(argWin, argEve), spr(1280, 720)
{
	// J̈ʒuƕݒ
	camera.glMoveTo(0.0, 30.0, 100.0);
	camera.glFocus(0.0, 30.0, 0.0);

	// Ɩ̐ݒ
	lightModel.setShape(&light);
	lightModel.setMaterial(White);
	lightModel.glFocus(-1.0, -1.0, -1.0);

	// fBXvCXgɃfƎ_ݒ
	scene.entryModel(&lightModel);
	scene.entryCamera(&camera);
	scene.setBGColor(1.0, 1.0, 1.0);

	// ^ZR̃f[^ǂݍ
	if(!chara.loadObjectData("girl/girl.mqo")) fl_alert("Object Read Error.");
	// ZbgAbvf[^ǂݍ
	if(!chara.loadJointData("girl/girl_setup.fkc")) fl_alert("Joint Read Error.");
	// [Vf[^ǂݍ݂ǂݍ
	if(!chara.loadMotionData("girl/walk.fkm")) fl_alert("Motion Read Error.");
	if(!chara.loadMotionData("girl/punch2.fkm")) fl_alert("Motion Read Error.");
	if(!chara.loadMotionData("girl/kick2.fkm")) fl_alert("Motion Read Error.");

	// 傢ƉĂ炤
	chara.getBaseModel()->glFocus(-1.0, 0.0, 0.0);

	// V[ւ̃Gg[(fk_Scene ̕ϐ & ēn)
	chara.entryScene(&scene);

	motionID = GIRL_STOP;

	spr.initFont("C:\\Windows\\fonts\\Meiryo.ttc");
	spr.text.setBackColor(0.0f, 0.0f, 0.0f, 0.5f);
	spr.drawText("V[2");
	spr.setPositionLT(-480.0, 270.0);
	spr.entryFirst(&scene, &camera);

	loader.setImage(&img);
	loader.start();

	return;
}

SceneMC::~SceneMC(void)
{
}

int	SceneMC::onPeriod(void)
{
	if(loader.isRunning()) {
		cout << "" << loader.getPhase() << "ڂǂłƂ`\n";
	}

	// L[ɂčĐĂ郂[V̏Ԃω
	if(ref_event->getKeyStatus('1') == FKUT_SW_DOWN) {
		motionID = GIRL_WALK;	// 0ŏɓǂݍ񂾃[V()\
	} else if(ref_event->getKeyStatus('2') == FKUT_SW_DOWN) {
		motionID = GIRL_PUNCH;	// 12Ԗڂ(ry
	} else if(ref_event->getKeyStatus('3') == FKUT_SW_DOWN) {
		motionID = GIRL_KICK;	// 23Ԗڂ(ry
	} else if(ref_event->getKeyStatus('0') == FKUT_SW_DOWN) {
		motionID = GIRL_STOP;	// -1͐Î~Ԃ\
	}

	// [V ID ɂāAĐ郂[V̎ނ𕪊򂷂

	// [v1񂲂Ƃ playMotion(Đԍ) ĂԂ1t[[Vi
	// Đԍ loadMotionData() œǂݍ񂾏(0X^[g)

	switch(motionID) {
		case GIRL_WALK:	// <-R(:)łBZ~R(;)ȂI
			// ƌĂёƌJԂĐ
			chara.playMotion(motionID);
			break;	// breaktȂƁȀ̏܂ŗĂႤ
		case GIRL_PUNCH:
		case GIRL_KICK:	// breaktɎcase΁Acaseŋʂ̏
			// 1񂫂̍ĐŎ~߂ꍇ́AIođΏ
			if(chara.isMotionFinished(motionID) == true) {
				// [VIĂꍇ͉Ȃ悤ɂA
				// ̃[V֌q肷΂悢

				// ̗Ⴞƍŏ̃t[߂A
				// ID-1ɂčĐ͎~߂悤ɂĂ
				// x2΍Đ
				chara.setNowFrame(motionID, 0);
				motionID = GIRL_STOP;
			} else {
				chara.playMotion(motionID);
			}
			break;
		default:	// ܂łŏcaseɓĂ͂܂Ȃꍇ̏
			break;
	}

	// [VĐ̃LN^[𓮂ɂ getBaseModel()-> ɑ΂
	// fk_Model ̖߂g
	if(ref_event->getSpecialKeyStatus(FK_UP) == FKUT_SW_PRESS) {
		chara.getBaseModel()->glTranslate(0.0, 0.5, 0.0);
	}
	if(ref_event->getSpecialKeyStatus(FK_DOWN) == FKUT_SW_PRESS) {
		chara.getBaseModel()->glTranslate(0.0, -0.5, 0.0);
	}

	// V[Jڏ
	if(ref_event->getSpecialKeyStatus(FK_F1) == FKUT_SW_DOWN) {
		return SCENE_OBB;
	}

	return 0;
}
