#pragma once
#include <FK/FK.h>
#include "FKUT/OBB.h"
#include "EventManager.h"
#include "FieldMap.h"
#include "FKUT/Audio.h"

class Player {
private:
	fk_Model	playerModel;
	fkut_OBB	playerOBB;
	fk_Cone		cone;

	fk_Vector	spd, acc;

	int			lockonID;
	fk_Vector	lockonPos[4];
	fk_Model	lockonMarker;

	void		procLockon(EventManager *argEve);

	fk_AudioWavBuffer	se1, se2;
	bool				se1_play, se2_play;


public:
	Player(void);
	~Player(void);

	void entryScene(fk_Scene *argScn);
	void removeScene(fk_Scene *argScn);

	fk_Model* getModel(void);
	fk_Vector getSpd(void);

	void update(FieldMap *argMap, EventManager *argEve, fk_Model *argCam);
};
