#include "Player.h"

Player::Player(void) : se1_play(false), se2_play(false), cone(8, 4.0, 8.0),
	lockonID(-1)
{
	// ̂̐ݒ
	playerModel.setShape(&cone);
	playerModel.setMaterial(Cyan);
	playerModel.setSmoothMode(true);
	playerModel.glMoveTo(0.0, 15.0, 0.0);
	playerOBB.setBlockSize(4.0, 4.0, 4.0);
	playerOBB.setModel(&playerModel);

	if(!se1.open("drum/BDTIGHT2.wav")) fl_alert("error!");
	if(!se2.open("drum/SDCRKRM.wav")) fl_alert("error!");

	lockonPos[0].set( 50.0, 0.0,  50.0);
	lockonPos[1].set(-50.0, 0.0,  50.0);
	lockonPos[2].set( 50.0, 0.0, -50.0);
	lockonPos[3].set(-50.0, 0.0, -50.0);

	lockonMarker.setShape(&cone);
	lockonMarker.setMaterial(Purple);
	lockonMarker.setSmoothMode(true);
	lockonMarker.glVec(0.0, -1.0, 0.0);
	lockonMarker.setDrawMode(FK_NONEMODE);

	return;
}

Player::~Player(void)
{
}

void Player::entryScene(fk_Scene *argScn)
{
	argScn->entryModel(&playerModel);
	argScn->entryModel(&lockonMarker);
}

void Player::removeScene(fk_Scene *argScn)
{
	argScn->removeModel(&playerModel);
	argScn->removeModel(&lockonMarker);
}

fk_Model* Player::getModel(void)
{
	return &playerModel;
}

fk_Vector Player::getSpd(void)
{
	return spd;
}

void Player::procLockon(EventManager *argEve)
{
	if(argEve->getKeyStatus('a') == FKUT_SW_DOWN) {
		++lockonID;
		if(lockonID > 3) {
			lockonID = -1;
			playerModel.glVec(0.0, 0.0, -1.0);
			lockonMarker.setDrawMode(FK_NONEMODE);
		}
	}
	if(lockonID != -1) {
		lockonMarker.glMoveTo(lockonPos[lockonID]);
		//lockonMarker.glTranslate(0.0, 10.0+3.0*cos((double)(timeGetTime()%31415)/500.0), 0.0);
		lockonMarker.glTranslate(0.0, 10.0, 0.0);
		lockonMarker.setDrawMode(FK_POLYMODE);
		playerModel.glFocus(lockonPos[lockonID]);
	}

	return;
}

void Player::update(FieldMap *argMap, EventManager *argEve, fk_Model *argCam)
{
	fk_Vector	vecF, vecR;
	
	vecF = argCam->getVec();
	vecF.y = 0.0;
	vecF.normalize();
	vecR = vecF ^ fk_Vector(0.0, 1.0, 0.0);

	// Wv̏x XZ ̊x悹
	if(argEve->getKeyStatus(' ') == FKUT_SW_DOWN) {
		acc.x = spd.x;
		acc.z = spd.z;
		acc.y = 2.0;
		se1.seek(0.0);
		se1_play = se1.play();
	}

	// n㎞͓x^A󒆂ł͉x
	spd.init();
	if(argEve->getSpecialKeyStatus(FK_UP) >= FKUT_SW_DOWN) {
		if(abs(acc.y) > 0.0) acc += vecF*0.1;
		else spd += vecF*0.5;
	}
	if(argEve->getSpecialKeyStatus(FK_DOWN) >= FKUT_SW_DOWN) {
		if(abs(acc.y) > 0.0) acc -= vecF*0.1;
		else spd -= vecF*0.5;
	}
	if(argEve->getSpecialKeyStatus(FK_LEFT) >= FKUT_SW_DOWN) {
		if(abs(acc.y) > 0.0) acc -= vecR*0.1;
		else spd -= vecR*0.5;
	}
	if(argEve->getSpecialKeyStatus(FK_RIGHT) >= FKUT_SW_DOWN) {
		if(abs(acc.y) > 0.0) acc += vecR*0.1;
		else spd += vecR*0.5;
	}
	if(spd.normalize()) spd *= 0.5;

	// d͉x
	acc.y -= 0.098;
	if(acc.x*acc.x + acc.z*acc.z > 0.5*0.5) {
		double tmpSpdLen = sqrt(acc.x*acc.x + acc.z*acc.z);
		acc.x *= 0.5/tmpSpdLen;
		acc.z *= 0.5/tmpSpdLen;
	} else {
		acc.x *= 0.9;
		acc.z *= 0.9;
	}

	// x𑬓xɏ悹
	spd += acc;

	// Փ˔Ăяo(nʂɒntrueԂ̂ŉx)
	if(argMap->procCollision(&playerOBB, &spd)) {
		acc.init();
		/*
		se2.seek(0.0);
		se2_play = se2.play();
		*/
	}
	// x𑀍샂fɉĎۂɓ
	playerModel.glTranslate(spd);

	if(se1_play) se1_play = se1.play();
	if(se2_play) se2_play = se1.play();

	procLockon(argEve);

	return;
}
