#include ".\filearchive.h"
#include <algorithm>
#include <sstream>

CFileArchive g_arc;

CFileArchive::CFileArchive(void)
{
	dispose();

	return;
}

CFileArchive::~CFileArchive(void)
{
	dispose();
}

void CFileArchive::init(string argArcFName, string argPass)
{
	arc.init();
	if(!arc.readArchive(argArcFName, argPass)) {
		cout << "failed!" << endl;
	}

	return;
}

void CFileArchive::dispose(void)
{
	extBuf.clear();
	arc.init();

	return;
}

void CFileArchive::setRealFileMode(bool argFlag)
{
	arc.setRealFileMode(argFlag);

	return;
}

bool CFileArchive::readMQOtoIFS(fk_IFSTexture *argShape, string argFName, string argObjName)
{
	extBuf.clear();
	if(!arc.getData(argFName, &extBuf)) return false;
	return argShape->readMQOData(&extBuf[0], argObjName);
}

bool CFileArchive::readMQOtoIFSet(fk_IndexFaceSet *argShape, string argFName, string argObjName)
{
	extBuf.clear();
	if(!arc.getData(argFName, &extBuf)) return false;
	return argShape->readMQOData(&extBuf[0], argObjName);
}

bool CFileArchive::readBMPtoIFS(fk_IFSTexture *argShape, string argFName)
{
	extBuf.clear();
	if(!arc.getData(argFName, &extBuf)) return false;
	return argShape->readBMPData(&extBuf[0]);
}

bool CFileArchive::readBMPtoIMG(fk_Image *argImage, string argFName)
{
	extBuf.clear();
	if(!arc.getData(argFName, &extBuf)) return false;
	return argImage->readBMPData(&extBuf[0]);
}

bool CFileArchive::readPNGtoIMG(fk_Image *argImage, string argFName)
{
	extBuf.clear();
	if(!arc.getData(argFName, &extBuf)) return false;
	return argImage->readPNGData(&extBuf[0]);
}

bool CFileArchive::readAscii(vector<string> *argBuffer, string argFName)
{
	static istringstream	iss;

	extBuf.clear();
	if(!arc.getData(argFName, &extBuf)) return false;

	/*
	static string	tmpStr;
	tmpStr.resize(extBuf.size());
	memcpy(&tmpStr.at(0), &extBuf.at(0), extBuf.size());
	*/

	iss.clear();
	extBuf.push_back('\0');
	iss.str((char*)&extBuf.at(0));
	argBuffer->clear();
	argBuffer->push_back("");
	while(getline(iss, argBuffer->back())) {
		argBuffer->push_back("");
	}

	return true;
}
