#include "FieldMap.h"

FieldMap::FieldMap(void)
{
	// ̂̐ݒ
	obb[0].setBlockSize(100.0, 100.0, 100.0);
	obb[0].setModel(&blockModel[0]);
	block[0].setSize(100.0, 100.0, 100.0);
	blockModel[0].glMoveTo(0.0, -50.0, 0.0);
	blockModel[0].setMaterial(Yellow);

	obb[1].setBlockSize(20.0, 10.0, 10.0);
	obb[1].setModel(&blockModel[1]);
	block[1].setSize(20.0, 10.0, 10.0);
	blockModel[1].glMoveTo(20.0, 5.0, 10.0);
	blockModel[1].setMaterial(Green);

	obb[2].setBlockSize(10.0, 50.0, 10.0);
	obb[2].setModel(&blockModel[2]);
	block[2].setSize(10.0, 50.0, 10.0);
	blockModel[2].glMoveTo(30.0, 25.0, -30.0);
	blockModel[2].setMaterial(Green);
	blockModel[2].glRotateWithVec(30.0, 25.0, -30.0, fk_X, FK_PI/2.5);

	obb[3].setBlockSize(30.0, 30.0, 10.0);
	obb[3].setModel(&blockModel[3]);
	block[3].setSize(30.0, 30.0, 10.0);
	blockModel[3].glMoveTo(-20.0, 15.0, -10.0);
	blockModel[3].setMaterial(Green);
	blockModel[3].glRotateWithVec(-20.0, 15.0, -10.0, fk_Y, FK_PI/2.5);

	obb[4].setBlockSize(20.0, 10.0, 40.0);
	obb[4].setModel(&blockModel[4]);
	block[4].setSize(20.0, 10.0, 40.0);
	blockModel[4].glMoveTo(-20.0, 5.0, 10.0);
	blockModel[4].setMaterial(Green);
	blockModel[4].glRotateWithVec(-20.0, 5.0, 10.0, fk_Z, FK_PI/2.5);

	obb[5].setBlockSize(10.0, 10.0, 10.0);
	obb[5].setModel(&blockModel[5]);
	block[5].setSize(10.0, 10.0, 10.0);
	blockModel[5].glMoveTo(0.0, 5.0, 0.0);
	blockModel[5].setMaterial(Green);

	obb[6].setBlockSize(10.0, 10.0, 10.0);
	obb[6].setModel(&blockModel[6]);
	block[6].setSize(10.0, 10.0, 10.0);
	blockModel[6].glMoveTo(7.5, 5.0, 0.0);
	blockModel[6].setMaterial(Green);

	return;
}

FieldMap::~FieldMap(void)
{
}

void FieldMap::entryScene(fk_Scene *argScene)
{
	for(int i = 0; i < 7; i++) {
		blockModel[i].setShape(&block[i]);
		blockModel[i].setSmoothMode(true);
		argScene->entryModel(&blockModel[i]);
	}

	return;
}

void FieldMap::removeScene(fk_Scene *argScene)
{
	for(int i = 0; i < 7; i++) {
		argScene->removeModel(&blockModel[i]);
	}

	return;
}

bool FieldMap::procCollision(fkut_OBB *playerOBB, fk_Vector *spd)
{
	// Ɨpϐ
	fk_Vector spdXZ, spdY, back, refV;
	// Yɔ͂true
	bool standFlag = false;

	// ubN̐FBՓ˂ubN͐ԂȂ
	for(int i = 0; i < 7; i++) {
		if(i == 0) {
			blockModel[i].setMaterial(Yellow);
		} else {
			blockModel[i].setMaterial(Green);
		}
	}
	// x
	spdXZ.set(spd->x, 0.0, spd->z);
	spdY.set(0.0, spd->y, 0.0);
	// XZ
	do {
		back.init();
		for(int i = 0; i < 7; i++) {
			if(obb[i].checkVSMovingOBB(*playerOBB, spdXZ+back, refV)) {
				back += -refV;
				blockModel[i].setMaterial(Red);
			}
		}
		if(abs(back.y) > 0.0) {
			standFlag = true;
		}
		spdXZ += back;
	} while(!back.isZero());
	// Y
	do {
		back.init();
		for(int i = 0; i < 7; i++) {
			if(obb[i].checkVSMovingOBB(*playerOBB, spdY+back, refV)) {
				back += -refV;
				blockModel[i].setMaterial(Red);
			}
		}
		if(abs(back.y) > 0.0) {
			standFlag = true;
		}
		spdY += back;
	} while(!back.isZero());

	// x
	*spd = spdXZ + spdY;

	return standFlag;
}
