#pragma once

#include <string>
#include <map>
#include <vector>

using namespace std;


class fkut_ConfigData {
private:
	map<string, string>	store;
	string				sepStr;

	vector<string>		SplitStr(const string &str, const string &token);

public:
	fkut_ConfigData(void);
	fkut_ConfigData(const string &cfgFileName);
	~fkut_ConfigData(void);

	void	init(void);
	bool	load(const string &cfgFileName);
	bool	save(const string &cfgFileName);

	bool	isExist(const string &key);

	bool	getBool(const string &key);
	int		getInteger(const string &key);
	double	getDouble(const string &key);
	string	getString(const string &key);

	void	setBool(const string &key, bool value);
	void	setInteger(const string &key, int value);
	void	setDouble(const string &key, double value);
	void	setString(const string &key, const string &value);
};
