#include "ConfigData.h"
#include <iostream>
#include <FK/Error.h>


vector<string> fkut_ConfigData::SplitStr(const string &argStr, const string &argToken)
{
	vector<string>		retStrArray;
	string::size_type	curPos = 0, nextPos = 0;

	while(nextPos != string::npos) {
		nextPos = argStr.find(argToken, curPos);
		retStrArray.push_back(argStr.substr(curPos, nextPos-curPos));
		curPos = nextPos+1;
	}

	return retStrArray;
}


fkut_ConfigData::fkut_ConfigData(void)
{
	init();
}

fkut_ConfigData::fkut_ConfigData(const string &cfgFileName)
{
	if(!load(cfgFileName)) init();
}

fkut_ConfigData::~fkut_ConfigData(void)
{
	init();
}

void fkut_ConfigData::init(void)
{
	store.clear();
	// ςΕʂ̋؂蕶g
	sepStr = "=";
}

bool fkut_ConfigData::load(const string &cfgFileName)
{
	ifstream		in_file(cfgFileName.c_str());
	string			lineStr;
	vector<string>	pairStr;

	if(!in_file.is_open()) return false;

	init();

	while(getline(in_file, lineStr)) {
		if(lineStr.find("=") == string::npos) continue;

		pairStr = SplitStr(lineStr, "=");
		if(pairStr.size() < 2) return false;

		store.insert(map<string, string>::value_type(pairStr[0], pairStr[1]));
	}

	return true;
}

bool fkut_ConfigData::save(const string &cfgFileName)
{
	ofstream						out_file(cfgFileName.c_str());
	map<string, string>::iterator	ite;
	
	if(!out_file.is_open()) return false;

	for(ite = store.begin(); ite != store.end(); ite++) {
		out_file << ite->first << "=" << ite->second << endl;
	}

	return true;
}

bool fkut_ConfigData::isExist(const string &key)
{
	if(store.find(key) == store.end()) return false;

	return true;
}

bool fkut_ConfigData::getBool(const string &key)
{
	if(!isExist(key)) return false;

	if(store[key] == "true") return true;
	else if(store[key] == "false") return false;

	return false;
}

int fkut_ConfigData::getInteger(const string &key)
{
	if(!isExist(key)) return 0;

	return atoi(store[key].c_str());
}

double fkut_ConfigData::getDouble(const string &key)
{
	if(!isExist(key)) return 0.0;

	return atof(store[key].c_str());
}

string fkut_ConfigData::getString(const string &key)
{
	if(!isExist(key)) return "";

	return store[key];
}

void fkut_ConfigData::setBool(const string &key, bool value)
{
	if(value) store.insert(map<string, string>::value_type(key, "true"));
	else store.insert(map<string, string>::value_type(key, "false"));
}

void fkut_ConfigData::setInteger(const string &key, int value)
{
	store.insert(map<string, string>::value_type(key, fk_StrPrintf("%d", value)));
}

void fkut_ConfigData::setDouble(const string &key, double value)
{
	store.insert(map<string, string>::value_type(key, fk_StrPrintf("%f", value)));
}

void fkut_ConfigData::setString(const string &key, const string &value)
{
	store.insert(map<string, string>::value_type(key, value));
}
