#pragma once

#include <FK/FK.h>
#include "FKUT/Input.h"

enum fkut_SwitchStatus {
	FKUT_SW_RELEASE,
	FKUT_SW_UP,
	FKUT_SW_DOWN,
	FKUT_SW_PRESS
};

enum fkut_JoyAxis {
	FKUT_AXIS1,
	FKUT_AXIS2,
	FKUT_AXIS3,
	FKUT_POV
};

class EventManager {
  private:
	bool		nowKeySt[256], nowSPKeySt[32], nowMouseSt[3];
	bool		preKeySt[256], preSPKeySt[32], preMouseSt[3];
	fk_Vector	nowMousePos, preMousePos;

	fkut_InputInfo		nowInput, preInput;

	fkut_SwitchStatus	GetSwitchStatus(bool now, bool pre);

  public:
	EventManager(void);
	~EventManager(void);

	void update(fk_Window *argWin, fkut_Input *argInput);

	fkut_SwitchStatus	getKeyStatus(char keyChar);
	fkut_SwitchStatus	getSpecialKeyStatus(fk_SpecialKey keyCode);
	fkut_SwitchStatus	getMouseStatus(fk_MouseButton buttonCode);
	fk_Vector			getMousePosition(void);
	fk_Vector			getMouseDifference(void);

	fkut_SwitchStatus	getJoyButtonStatus(int joyID, int btnID);
	int					getJoyDirection(int joyID);
	fkut_SwitchStatus	getJoyDirectionStatus(int joyID, int dirID);
	fk_Vector			getJoyAxisValue(int joyID, fkut_JoyAxis axisID);
};
