#include "EventManager.h"


EventManager::EventManager(void)
{
	int	i;

	for(i = 0; i < 256; i++) {
		preKeySt[i] = false;
		nowKeySt[i] = false;
	}
	for(i = 0; i < 32; i++) {
		preSPKeySt[i] = false;
		nowSPKeySt[i] = false;
	}
	for(i = 0; i < 3; i++) {
		preMouseSt[i] = false;
		nowMouseSt[i] = false;
	}

	nowMousePos.init();
	preMousePos.init();

	memset(&nowInput, 0, sizeof(fkut_InputInfo));
	nowInput.pov = -1;
	preInput = nowInput;

	return;
}

EventManager::~EventManager(void)
{
}

void EventManager::update(fk_Window *argWin, fkut_Input *argInput)
{
	int	i, x, y;

	for(i = 0; i < 256; i++) {
		preKeySt[i] = nowKeySt[i];
		nowKeySt[i] = argWin->getKeyStatus((char)i, false);
	}
	for(i = 0; i < 32; i++) {
		preSPKeySt[i] = nowSPKeySt[i];
		nowSPKeySt[i] = argWin->getSpecialKeyStatus((fk_SpecialKey)i, false);
	}
	for(i = 0; i < 3; i++) {
		preMouseSt[i] = nowMouseSt[i];
		nowMouseSt[i] = argWin->getMouseStatus((fk_MouseButton)i, false);
	}

	preMousePos = nowMousePos;
	argWin->getMousePosition(&x, &y, false);
	nowMousePos.set((double)x, (double)y, 0.0);

	if(argInput != NULL) {
		preInput = nowInput;
		nowInput = argInput->getInputStatus(0);
	}

	return;
}

fkut_SwitchStatus EventManager::GetSwitchStatus(bool now, bool pre)
{
	switch((int)now*2 + (int)pre) {
	  case 0:
		return FKUT_SW_RELEASE;
	  case 1:
		return FKUT_SW_UP;
	  case 2:
		return FKUT_SW_DOWN;
	  case 3:
		return FKUT_SW_PRESS;
	  default:
		return FKUT_SW_RELEASE;
	}
}

fkut_SwitchStatus EventManager::getKeyStatus(char argKey)
{
	return GetSwitchStatus(nowKeySt[(int)argKey], preKeySt[(int)argKey]);
}

fkut_SwitchStatus EventManager::getSpecialKeyStatus(fk_SpecialKey argKey)
{
	return GetSwitchStatus(nowSPKeySt[(int)argKey], preSPKeySt[(int)argKey]);
}

fkut_SwitchStatus EventManager::getMouseStatus(fk_MouseButton argButton)
{
	return GetSwitchStatus(nowMouseSt[(int)argButton], preMouseSt[(int)argButton]);
}

fk_Vector EventManager::getMousePosition(void)
{
	return nowMousePos;
}

fk_Vector EventManager::getMouseDifference(void)
{
	return (nowMousePos-preMousePos);
}

fkut_SwitchStatus EventManager::getJoyButtonStatus(int joyID, int buttonID)
{
	return GetSwitchStatus(nowInput.button[buttonID], preInput.button[buttonID]);
}

int EventManager::getJoyDirection(int joyID)
{
	if( nowInput.up & !nowInput.down & !nowInput.left & !nowInput.right) return 8;
	if(!nowInput.up &  nowInput.down & !nowInput.left & !nowInput.right) return 2;
	if(!nowInput.up & !nowInput.down &  nowInput.left & !nowInput.right) return 4;
	if(!nowInput.up & !nowInput.down & !nowInput.left &  nowInput.right) return 6;
	if( nowInput.up & !nowInput.down &  nowInput.left & !nowInput.right) return 7;
	if( nowInput.up & !nowInput.down & !nowInput.left &  nowInput.right) return 9;
	if(!nowInput.up &  nowInput.down &  nowInput.left & !nowInput.right) return 1;
	if(!nowInput.up &  nowInput.down & !nowInput.left &  nowInput.right) return 3;

	return 5;
}

fkut_SwitchStatus EventManager::getJoyDirectionStatus(int joyID, int dirID)
{
	bool preState = false;

	switch(dirID) {
	case 8:
		preState = ( preInput.up & !preInput.down & !preInput.left & !preInput.right);
		break;
	case 2:
		preState = (!preInput.up &  preInput.down & !preInput.left & !preInput.right);
		break;
	case 4:
		preState = (!preInput.up & !preInput.down &  preInput.left & !preInput.right);
		break;
	case 6:
		preState = (!preInput.up & !preInput.down & !preInput.left &  preInput.right);
		break;
	case 7:
		preState = ( preInput.up & !preInput.down &  preInput.left & !preInput.right);
		break;
	case 9:
		preState = ( preInput.up & !preInput.down & !preInput.left &  preInput.right);
		break;
	case 1:
		preState = (!preInput.up &  preInput.down &  preInput.left & !preInput.right);
		break;
	case 3:
		preState = (!preInput.up &  preInput.down & !preInput.left &  preInput.right);
		break;
	default:
		preState = (!preInput.up & !preInput.down & !preInput.left & !preInput.right);
		break;
	}

	return GetSwitchStatus((getJoyDirection(joyID) == dirID), preState);
}

fk_Vector EventManager::getJoyAxisValue(int joyID, fkut_JoyAxis axisID)
{
	static fk_Vector retVal;
	if(axisID != FKUT_POV) {
		retVal.set((double)nowInput.x[(int)axisID], -(double)nowInput.y[(int)axisID]);
	} else {
		switch(nowInput.pov) {
		case -1:
			retVal.init();
			break;
		case 0:
			retVal.set( 0.0,  1.0);
			break;
		case 4500:
			retVal.set( 1.0,  1.0);
			break;
		case 9000:
			retVal.set( 1.0,  0.0);
			break;
		case 13500:
			retVal.set( 1.0, -1.0);
			break;
		case 18000:
			retVal.set( 0.0, -1.0);
			break;
		case 22500:
			retVal.set(-1.0, -1.0);
			break;
		case 27000:
			retVal.set(-1.0,  0.0);
			break;
		case 31500:
			retVal.set(-1.0,  1.0);
			break;
		}
	}
	return retVal;
}
