#pragma once
#include <FK/FK.h>
#include "FKUT/FrameController.h"
#include "FKUT/Fullscreen.h"
#include "FKUT/Input.h"
#include "EventManager.h"

enum fkut_LoopState {
	FKUT_EXIT,
	FKUT_RUNNING,
	FKUT_SLEEPING
};

class fkut_AppBase {
private:
	void	Sleep(unsigned long);
	void	ToggleScreen(void);

protected:
	Fl_Window	*mainWin;
	fk_Window	*drawWin;

	fkut_Input	input;
	bool		inputReady;

	fkut_FrameController	fps;
	CFullscreenControler	fsc;
	EventManager			eveMan;


	virtual void	init(void) = 0;
	virtual bool	procLoop(void) = 0;

	fkut_LoopState	updateWindow(void);

public:
	fkut_AppBase(Fl_Window *argMainWin, fk_Window *argDrawWin);
	virtual ~fkut_AppBase(void);

	int				run(void);
};
