#include "AppBase.h"

fkut_AppBase::fkut_AppBase(Fl_Window *argMainWin, fk_Window *argDrawWin)
{
	mainWin = argMainWin;
	drawWin = argDrawWin;

	mainWin->end();
	mainWin->show();
	fk_Material::initDefault();
	Fl::set_font(FL_HELVETICA, "lr SVbN");

	if(input.init(fl_display, fl_xid(mainWin)) == S_OK) {
		inputReady = true;
	} else {
		inputReady = false;
	}

	fsc.init(mainWin, drawWin);
	fps.SetFPS(60);

	// mainWin->cursor(FL_CURSOR_NONE);

	return;
}

fkut_AppBase::~fkut_AppBase(void)
{
	input.uninit();
	inputReady = false;
	mainWin->hide();

	drawWin = NULL;
	mainWin = NULL;
}

// X[v}`vbgtH[pɃbsO
void fkut_AppBase::Sleep(unsigned long argMSec)
{
	unsigned long regTime = drawWin->getNow();
	while(drawWin->getNow() - regTime < argMSec) {
#ifdef WIN32
		::Sleep(1);
#else
		Fl::wait(0.001);
#endif
	}
	return;
}

// XN[[h̃nhO
void fkut_AppBase::ToggleScreen(void)
{
	// ALT+ENTERŃtXN[ƃEBhE[h؂ւ
	if(eveMan.getSpecialKeyStatus(FK_ALT_L) >= FKUT_SW_DOWN
	|| eveMan.getSpecialKeyStatus(FK_ALT_R) >= FKUT_SW_DOWN) {
		if(eveMan.getSpecialKeyStatus(FK_ENTER) == FKUT_SW_DOWN) {
			if(fsc.isFullscreen() == true) {
				fsc.changeToWindow();
			} else {
				fsc.changeToFullscreen();
			}
		}
	}
	// EBhẼtH[JXOꂽEBhE[hɖ߂
	if(Fl::focus() != mainWin) {
		if(fsc.isFullscreen() == true) {
			fsc.changeToWindow();
		}
	}

	return;
}

fkut_LoopState fkut_AppBase::updateWindow(void)
{
	// t[
	fps.TimeRegular();
	// EBhẺ`FbN
	if(mainWin->visible() == 0) {
		if(Fl::check() == 0) {
			return FKUT_EXIT;
		} else {
			return FKUT_SLEEPING;
		}
	}
	// `tO
	if(fps.GetDrawFlag() == true) drawWin->drawWindow();
	// `恕bZ[W
	if(Fl::check() == 0) return FKUT_EXIT;
	if(drawWin->winOpenStatus() == false) return FKUT_SLEEPING;

	// ̓tO
	if(inputReady == true) input.update();
	eveMan.update(drawWin, &input);
	// XN[[h
	ToggleScreen();

	return FKUT_RUNNING;
}

int fkut_AppBase::run(void)
{
	// R[
	init();

	// C[v
	while(true) {
		// `恕bZ[W
		switch(updateWindow()) {
		case FKUT_EXIT:
			return 0;
		case FKUT_SLEEPING:
			Sleep(1);
			continue;
		}

		// [vR[
		if(procLoop() == false) break;
	}
	
	return 0;
}
