#pragma once
#include <FK/FK.h>
#include "FrameController.h"
#include "GuideObject.h"
#include "TrackBall.h"
#include "Input.h"


enum fkut_SwitchStatus {
	FKUT_SW_RELEASE,
	FKUT_SW_UP,
	FKUT_SW_DOWN,
	FKUT_SW_PRESS
};

class CMotionCharactor;

class fkut_SimpleWindow {
private:
	friend class fkut_CubicModel;
	friend class fkut_SpriteModel;

	Fl_Window	*mainWin;
	fk_Window	*drawWin;

	fkut_SimpleWindow		*ref_child;
	fkut_FrameController	fps_admin;
	fkut_GuideObject		guide;
	fk_TrackBall			*tb;

	fk_Scene	scene;
	fk_Light	lightShape;
	fk_Model	camera, light;

	fk_Model	*ref_camera;

	int		fps;
	bool	tbFlag, childMode;

	static bool	prevKeySt[256], prevSPKeySt[32], prevMouseSt[3];

	void PushPrevStatus(void);

public:
	fkut_Input		input;
	fkut_InputInfo	prevInput, nowInput;
	bool			inputEnable;

	fkut_SimpleWindow(void);
	fkut_SimpleWindow(fkut_SimpleWindow &parent);
	~fkut_SimpleWindow(void);

	void setSize(int w, int h);
	void setInnerSize(int x, int y, int w, int h);
	void setBGColor(double r, double g, double b);
	void setFPS(int fps);
	void setTrackBallMode(bool mode);

	void showGuide(fkut_GuideMode mode = FKUT_AXIS_X | FKUT_AXIS_Y | FKUT_AXIS_Z | FKUT_GRID_XZ);
	void hideGuide(void);
	void setGuideAxisWidth(double width);
	void setGuideGridWidth(double width);
	void setGuideScale(double scale);
	void setGuideNum(int num);

	void setCameraPos(double x, double y, double z);
	void setCameraFocus(double x, double y, double z);
	void setCameraModel(fk_Model &model);
	void setCameraDefault(void);

	void entry(fk_Model &model);
	void entry(fk_Model &model, fkut_GuideObject &guide);
	void entry(fkut_SpriteModel &model);
	void entry(CMotionCharactor &chara);
	void remove(fk_Model &model);
	void remove(fk_Model &model, fkut_GuideObject &guide);
	void remove(fkut_SpriteModel &model);
	void remove(CMotionCharactor &chara);

	void open(void);
	void close(void);

	bool update(void);

	fkut_SwitchStatus	getKeyStatus(char keyChar);
	fkut_SwitchStatus	getSpecialKeyStatus(fk_SpecialKey keyCode);

	fkut_SwitchStatus	getMouseStatus(fk_MouseButton buttonCode);
	fk_Vector			getMousePosition(void);

	bool isModelPicked(fk_Model &model, int pixel = 1, int mouseX = -1, int mouseY = -1);
};
