#ifndef _FKP_MOTIONCHARACTOR_H_HEADER_
#define _FKP_MOTIONCHARACTOR_H_HEADER_

#include <FK/FK.h>
#include "./MotionData.h"


class CMotionCharactor {
private:
	vector<fk_Model *>			jointModel;
	vector<fk_Shape *>			mesh;
	vector<fk_Model *>			objModel;

	vector<fk_Material>			matPalette;
	vector<int>					matTable;
	vector<fk_Image *>			texImage;
	vector<string>				texName;
	vector<int>					texTable;

	string						mqoName;
	int							objNum;
	vector<string>				objName;
	map<int, int>				parentTable;
	bool						parentConnect;

	vector<vector<CKeyFrameMotion> >	keyFrameData;
	vector<int>							nowFrame, maxFrame;

	int			prevPlayMotionID, loopCnt;

	fk_Scene	*ref_scene;

	fk_Model	absParent;

	typedef map<int, int>::iterator parentIte;

	void init(void);
	bool enumObjectName(const string &);

	// IC[p
	bool LoadMotionDataEuler(const string &);
	// XP[Ή
	bool LoadMotionDataEulerScale(const string &);

	static map<string, fk_Shape *>		shapeCache;
	static map<string, fk_Image *>		imageCache;
	static map<fk_BaseObject *, int>	countCache;
	static map<fk_BaseObject *, string>	reverseCache;

public:
	CMotionCharactor(void);
	~CMotionCharactor(void);

	bool loadObjectData(const string &);
	bool loadJointData(const string &);
	bool loadMotionData(const string &);

	void entryScene(fk_Scene *);
	void removeScene(fk_Scene *);
	void setDrawMode(bool);

	void setMarkerShape(fk_Shape *);

	int getObjectNum(void);

	fk_Model * getBaseModel(void)
	{
		return &absParent;
	};
	fk_Model * getObjectModel(int);
	fk_Model * getJointModel(int);

	void jointToPoser(void);

	int getNowFrame(int);
	int getTotalFrame(int);
	bool playMotion(int);
	void stillMotion(int, int);

	void setNowFrame(int, int);
	bool isMotionFinished(int);
	int getLoopCount(void);

	// IuWFNgƂ̕\^\
	void objShowHide(int);
};

vector<string> fk_StrSplit(const string &, const string &);

#endif
