#pragma once

#define DIRECTINPUT_VERSION		DIRECTINPUT_HEADER_VERSION

#ifdef USE_OFFICIAL_DXSDK
  #include <dinput.h>
#else
  #include "dinput/dinput.h"
#endif // USE_OFFICIAL_DXSDK

#include <map>
#include <vector>

// FKUTtH_vWFNgt@CtH_ɒuꍇ̃pXwɂȂĂ܂
// uꏊꍇ͓KXύXĂ
#ifndef USE_OFFICIAL_DXSDK
  #pragma comment(lib,"FKUT/dinput/dxguid.lib")
  #pragma comment(lib,"FKUT/dinput/dinput8.lib")
#else
  #pragma comment(lib,"dxguid.lib")
  #pragma comment(lib,"dinput8.lib")
#endif


struct fkut_InputInfo {
	// Ă{^trueAĂȂfalse
	bool	button[32];
	// XeBbNƂ㉺E̓͏
	bool	up;
	bool	down;
	bool	left;
	bool	right;
	// x[0],y[0]XeBbNAx[1],y[1]EXeBbÑAiOl
	// 360Rg[x[2],y[2]EXeBbÑAiOlŁAx[1]LT(+),RT(-)݂̉ɑΉ
	short	x[3];
	short	y[3];
	// -1POV͏ԁA^0ƂAv4500l
	int		pov;
};

enum fkut_AxisDirection {
	AXIS1_X = 1,
	AXIS1_Y,
	AXIS2_X,
	AXIS2_Y,
	AXIS3_X,
	AXIS3_Y
};

enum fkut_RawAxis {
	AXIS_X_POS = 0,
	AXIS_X_NEG,
	AXIS_Y_POS,
	AXIS_Y_NEG,
	AXIS_Z_POS,
	AXIS_Z_NEG,
	AXIS_RX_POS,
	AXIS_RX_NEG,
	AXIS_RY_POS,
	AXIS_RY_NEG,
	AXIS_RZ_POS,
	AXIS_RZ_NEG
};


#include <stdio.h>

class fkut_Input {
private:
	static const int BUTTON_NUM = 32;
	static const int DIMGR_BUFFER_SIZE = 256;
	static const int INPUT_DEVICE_NUM = 16;
	static const int MOUSE_BUTTON_MAX = 8;
	static const int KEY_NUM = 256;

	int		buttonSwap[INPUT_DEVICE_NUM][BUTTON_NUM], axisSwap[INPUT_DEVICE_NUM][2*3];
	DWORD	axisMap[4*3], povMap[8], keyMap[BUTTON_NUM];

	struct AxisParam {
		int pos, neg, border;
	};
	std::map<int, AxisParam>	axisParams[INPUT_DEVICE_NUM];

    // Rs[RXgN^͖
    fkut_Input(const fkut_Input& other);
    // Zq
    fkut_Input& operator=(const fkut_Input& other);

	//L[{[h̃o[ϐ
	bool m_Key[KEY_NUM];

	//}EX̃o[ϐ
	POINT	m_MouseWorldPos;	//}EX̐΍W
	int		m_MouseWheel;
	POINT	m_MouseLocalPos;	//}EX̃[JW
	bool	m_Button[MOUSE_BUTTON_MAX];
	bool	m_LastButton[MOUSE_BUTTON_MAX];

	//Joỹo[ϐ
	DWORD					m_JoyCount;
	DWORD					m_JoyMaxCount;
	fkut_InputInfo*			m_JoyButton;
	int						m_AllowX[INPUT_DEVICE_NUM];		//XW̗V	0`1000̒lłBႢقǕq
	int						m_AllowY[INPUT_DEVICE_NUM];		//YW̗V	0`1000̒lłBႢقǕq
	int						m_AllowMin[INPUT_DEVICE_NUM];	// AiOXeBbN̒lŗLƂ͈͂w肵܂
	int						m_AllowMax[INPUT_DEVICE_NUM];	// AiOXeBbN̒lŗLƂ͈͂w肵܂

	//foCX֘Ão[ϐ
	HWND					m_hwnd;
	LPDIRECTINPUT8			m_Input;
	LPDIRECTINPUTDEVICE8	m_KeyBoardDevice;
	LPDIRECTINPUTDEVICE8	m_MouseDevice;
	LPDIRECTINPUTDEVICE8	m_JoyStciDevice[INPUT_DEVICE_NUM];
	DIDEVCAPS				m_DevCaps;
	DIDEVICEOBJECTDATA		m_DeviceObject[DIMGR_BUFFER_SIZE];  // Receives buffered data

	//=====================
	//Update֘A
	//=====================
	HRESULT UpdateJoy(void);
	HRESULT UpdateMouse(void);
	HRESULT UpdateKey(void);

	//===========================
	//JoỹR[obN֐
	//===========================
	static BOOL CALLBACK EnumSizesCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID lpvRef);
	static BOOL CALLBACK EnumJoysticksCallback(const DIDEVICEINSTANCE* lpddi, LPVOID lpContext);

	short	AdjustParam(int, short);
	void	SetAxisParam(int, int, short);

public:
	//==============================
	//	RXgN^EfXgN^
	//==============================
	fkut_Input(void);
	~fkut_Input(void);

	//==============================
	//	}EXEL[{[h擾֘A
	//==============================
	/*
		ւ͎͂ŎgȂgĂłA
		̃o[Wł͒JȃT|[g͂Ă܂B
		ɃQ[pbhƃL[{[hɃNɂĂ͉̖̕߂֗Ȃ̂ŁA
		̕g悤ɂĂB
	*/

	// }EX֘A
	POINT&	GetMouseLocalPos(void);
	POINT&	GetMouseWorldPos(void);
	bool	GetMouseButton(DWORD keycode);
	bool	GetLastMouseButton(DWORD keycode);
	int		GetMouseWheel(void);

	// L[֘A
	bool	GetKey(const DWORD keycode);

	//==============================
	//	{
	//==============================

	//! 
	/*
		ŏɕK1ĂłB^C~OƃVrAŁA
		uFl_Window̕ϐɑ΂show()Ă񂾌vɌĂԕKv܂B
		ɂ(fl_display, fl_xid(&Fl_Window̕ϐ))ƋLq܂B
		fl_xid()Ƃ֐gɂ#include <Fl/x.h>KvɂȂ܂B
		LqƂăTvQƂĂB
		ƏςނS_OKƂԒlԂ܂B
	*/
	HRESULT init(HINSTANCE hinst, HWND hwnd);

	//! Еt
	/*
		vOOɌĂт܂BYĂfXgN^ŌĂяo܂A
		ŌĂłSmłB
	*/
	HRESULT uninit(void);

	//! XV
	/*
		t[Ƃɓ͏ԂXV܂B`揈̌ɂłĂłB
		Ă΂ȂƁAJԂĂ͂ɔĂ܂B
	*/
	HRESULT update(void);

	//==============================
	//	WCXeBbN֘A
	//==============================

	//!	WCXeBbN{擾
	/*
		init()_ŉ{̃WCXeBbNF擾܂B
		init()Ă甲Ă֒mł܂B
	*/
	inline DWORD	getJoyCount(void);

	//!	WCXeBbN̏擾
	/*
		WCXeBbN̏Ԃ̂܂܂擾܂B
		fkut_InputInfo^̃|C^ϐpӂAŎ󂯎ĂB
		{^̓ւ͔fꂽ񂪕Ԃ܂AL[{[hł֑͍̑l܂B
		L[{[hƏ{ꍇgetInputStatus()߂łB
		ɂ͎擾WCXeBbNIDԍw肵܂B1{ڂ0ɂȂ܂B
		ȃWCXeBbN̔ԍw肳ꂽꍇNULLԂ܂B
	*/
	fkut_InputInfo*	getJoyStick(DWORD inJoyIndex);

	//!	XeBbN̂lݒ
	/*
		XeBbN͏\L[Ɏg邱ƂłA
		̍ۂɂǂ̂炢XeBbN|炻̕ւ̓͂ƌȂAݒł܂B
		1ɃWCXeBbNIDԍA2͉A3͏ĉlw肵܂B
		2w肷֐́AID0̃WCXeBbNւ̎w\܂B
		l͈̔͂0`1000łBl500ɂȂĂ܂B
	*/
	void			setBorder(int joyIndex, int borderX, int borderY);
	void			setBorder(int borderX, int borderY);

	//!	XeBbN̍ŏEől̐ݒ
	/*
		XeBbNԂl͔Ƀu邽߁AĂȂĂ҂0ɂȂȂA
		ڈt|Ă1000ɂȂȂ肵܂B
		̂߁Al0ƌȂAl傫1000ƌȂƂݒ肪ł܂B
		l΂Jbg邾ł͂ȂAL͈͂ƂȂl0`1000͈̔͂Ƀ}bsO܂̂ŁA
		Q[̏͏0`1000͈̔͂ŏlĂΌ\łB
		1ɃWCXeBbNIDԍA2ɍŏlA3ɍőlw肵܂B
		2w肷֐́AID0̃WCXeBbNւ̎w\܂B
		l͈̔͂0`1000łAŏlől傫悤Ȏwꍇ̓G[ɂȂ̂ŁA
		ݒύXɖ܂Bl͍ŏl200Aől900łB
	*/
	void			setMinMax(int joyIndex, int min, int max);
	void			setMinMax(int min, int max);

	//!	{^̓ւݒ
	/*
		{^̔ԍւ邱Ƃł܂B
		1ɃWCXeBbNIDԍA2ɃQ[ł̃{^ԍA3Ƀpbh̐̃{^ԍw肵܂B
		l̓{^̐̔ԍ̂܂܂ΉÂĂ܂BQ[ł̃{^̂񋓌^ŖOtāA
		Ήt̂߂łBɂĔԍ0X^[gȂ̂ŒӂĂB
	*/
	void			setButtonSwap(int joyIndex, int id, int raw);

	//!	̓ւݒ
	/*
		XeBbN̎ƌւ邱Ƃł܂B
		1ɃWCXeBbNIDԍA2ɃQ[ł̎ԍA3Ƀpbh̐̎ԍw肵܂B
		Q[̎ԍ AXIS1_X, AXIS1_Y, AXIS2_X, AXIS2_Y, AXIS3_X, AXIS3_Y ̉ꂩw肵܂B
		pbh̎ԍ AXIS_X_POS, AXIS_Y_POS, AXIS_Z_POS, AXIS_RX_POS, AXIS_RY_POS, AXIS_RZ_POS ̉ꂩA
		POS ̕ NEG ɕύXēlw肵ĂB
		NEG ɂꍇ́Apbh瓾鍶E㉺̕𔽓]l擾悤ɂȂ܂B
		l̑Ή͈ȉ̒ʂłBgppbhRg[ϊɉĕύXĂB
			AXIS1_X = AXIS_X_POS,  AXIS1_Y = AXIS_Y_POS,
			AXIS2_X = AXIS_Z_POS,  AXIS2_Y = AXIS_RZ_POS,
			AXIS3_X = AXIS_RX_POS, AXIS3_Y = AXIS_RY_POS
	*/
	void			setAxisSwap(int joyIndex, fkut_AxisDirection id, fkut_RawAxis raw);

	//! ̃{^蓖
	/*
		XeBbN̎{^ƂĈƂł܂BXBox360Rg[̋@\łB
		1ɃWCXeBbNIDԍA2ɎԍA3+̃{^ԍA4-̃{^ԍA
		5Ƀ{^Ɣf邵lw肵܂B
		ȉID0ɐڑꂽXBox360Rg[APSnRg[݊̊蓖ĂɕύXR[hłB
		ftHgAXIS2_X(AXIS_Z)LT,RTɑΉ܂AEXeBbN2ɃATCݒ܂߂ėᎦ܂B
			// 23ւ
			setAxisSwap(0, AXIS2_X, AXIS_RX_POS);
			setAxisSwap(0, AXIS2_Y, AXIS_RY_POS);
			setAxisSwap(0, AXIS3_X, AXIS_Z_POS);
			setAxisSwap(0, AXIS3_Y, AXIS_RZ_POS);
			// ւ̎3X6,7ԂɊ蓖
			setAxisToButton(0, AXIS3_X, 6, 7, 500);
			// {^ւ
			setButtonSwap(0,  8, 6);	// Back->Select
			setButtonSwap(0,  9, 7);	// Start->Start
			setButtonSwap(0, 10, 8);	// StickL->StickL
			setButtonSwap(0, 11, 9);	// StickR->StickR
	*/
	void			setAxisToButton(int joyIndex, fkut_AxisDirection axisID, int posBtn, int negBtn, int border);

	//! ̃{^蓖ĉ
	/*
		XeBbN̎{^Ɋ蓖Ăݒ܂B
	*/
	void			clearAxisToButton(int joyIndex);

	//!	{^ɑ΂L[{[h̃ATC
	/*
		WCXeBbÑ{^̑ɎgpL[ݒ肵܂B
		1̓Q[ł̃{^ԍA2ɃL[R[hw肵܂B
		Q[ł̃{^ԍƂ́AsetButtonSwap()Őݒ肵uւ̔ԍvw܂B

		L[R[h̎ẃAdinput.hŒ`ĂuDIK_vŎn܂萔gčs܂B
		L[{[hł֑̑̓WCXeBbNID0̂̂ɑ΂Ă̂ݗLłB
	*/
	void			setKeyAssign(int id, DWORD keycode);

	//!	XeBbNɑ΂L[{[h̃ATC
	/*
		WCXeBbÑXeBbN̑ɎgpL[ݒ肵܂B
		10ōXeBbN(ʏ\L[ƂĎg)A1ŉEXeBbNA23Ԗڂ̎\܂B
		2ȍ~͏ԂɁA㉺EɑΉL[R[hw肵܂B

		L[R[h̎ẃAdinput.hŒ`ĂuDIK_vŎn܂萔gčs܂B
		L[{[hł֑̑̓WCXeBbNID0̂̂ɑ΂Ă̂ݗLłB
	*/
	void			setAxisAssign(int axis_id, DWORD up, DWORD dn, DWORD lt, DWORD rt);

	//!	POV{^ɑ΂L[{[h̃ATC
	/*
		WCXeBbNPOV{^̑ɎgpL[ݒ肵܂B
		1珇ԂɁAA^AEAAEAA^AEɑΉL[R[hw肵܂B

		L[R[h̎ẃAdinput.hŒ`ĂuDIK_vŎn܂萔gčs܂B
		L[{[hł֑̑̓WCXeBbNID0̂̂ɑ΂Ă̂ݗLłB
	*/
	void			setPOVAssign(DWORD ul, DWORD u, DWORD ur, DWORD l, DWORD r, DWORD dl, DWORD d, DWORD dr);

	//!	L[{[h܂߂͏Ԏ擾
	/*
		͏Ԃ擾܂Bfkut_InputInfo^̕ϐ炩ߗpӂAŎ󂯎ĂB
		ɂ̓WCXeBbNIDw肵܂A0w肵ꍇ̓WCXeBbNڑĂȂꍇA
		L[{[h̓͂fꂽ񂪕ԂĂ܂BڑĂꍇ̓WCXeBbN̏ԂԂ܂B
	*/
	fkut_InputInfo	getInputStatus(int = 0);

};
