#include "GuideObject.h"
#include <FK/Scene.h>

fkut_GuideObject::fkut_GuideObject(void)
{
	axis[0].pushLine(fk_Vector(0.0, 0.0, 0.0), fk_Vector(1.0, 0.0, 0.0));
	axis[1].pushLine(fk_Vector(0.0, 0.0, 0.0), fk_Vector(0.0, 1.0, 0.0));
	axis[2].pushLine(fk_Vector(0.0, 0.0, 0.0), fk_Vector(0.0, 0.0, 1.0));
	axisModel[0].setLineColor(1.0, 0.0, 0.0);
	axisModel[1].setLineColor(0.0, 1.0, 0.0);
	axisModel[2].setLineColor(0.0, 0.0, 1.0);
	for(int i = 0; i < 3; i++) {
		axisModel[i].setShape(&axis[i]);
		gridModel[i].setShape(&grid);
	}
	gridModel[1].glAngle(0.0, FK_PI*0.5, 0.0);
	gridModel[2].glAngle(0.0, 0.0, FK_PI*0.5);

	setAxisWidth(4.0);
	setGridWidth(1.0);
	setScale(5.0);
	setNum(20);

	return;
}

fkut_GuideObject::~fkut_GuideObject(void)
{
}

void fkut_GuideObject::setAxisWidth(double argWidth)
{
	for(int i = 0; i < 3; i++) {
		axisModel[i].setWidth(argWidth);
	}

	return;
}

void fkut_GuideObject::setGridWidth(double argWidth)
{
	for(int i = 0; i < 3; i++) {
		gridModel[i].setWidth(argWidth);
	}

	return;
}

void fkut_GuideObject::setScale(double argScale)
{
	if(argScale < FK_EPS) return;

	scale = argScale;

	for(int i = 0; i < 3; i++) {
		axisModel[i].setScale(scale*(double)(num/2));
		gridModel[i].setScale(scale);
	}

	return;
}

void fkut_GuideObject::setNum(int argNum)
{
	if(argNum <= 0) return;

	num = argNum;

	grid.allClear();
	for(int i = 0; i <= num; i++) {
		grid.pushLine(fk_Vector(double(i-num/2), 0.0 , double(num/2)), fk_Vector(double(i-num/2), 0.0 , -double(num/2)));
		grid.pushLine(fk_Vector(-double(num/2), 0.0 , double(num/2-i)), fk_Vector(double(num/2), 0.0 , double(num/2-i)));
	}

	for(int i = 0; i < 3; i++) {
		axisModel[i].setScale(scale*(double)(num/2));
	}

	return;
}

void fkut_GuideObject::setParent(fk_Model *argModel)
{
	for(int i = 0; i < 3; i++) {
		axisModel[i].setParent(argModel, false);
		gridModel[i].setParent(argModel, false);
	}

	return;
}

void fkut_GuideObject::entryScene(fk_Scene *scene, fkut_GuideMode mode)
{
	if((mode & FKUT_AXIS_X) != FKUT_NO_GUIDE) {
		scene->entryModel(&axisModel[0]);
	}
	if((mode & FKUT_AXIS_Y) != FKUT_NO_GUIDE) {
		scene->entryModel(&axisModel[1]);
	}
	if((mode & FKUT_AXIS_Z) != FKUT_NO_GUIDE) {
		scene->entryModel(&axisModel[2]);
	}
	if((mode & FKUT_GRID_XZ) != FKUT_NO_GUIDE) {
		scene->entryModel(&gridModel[0]);
	}
	if((mode & FKUT_GRID_XY) != FKUT_NO_GUIDE) {
		scene->entryModel(&gridModel[1]);
	}
	if((mode & FKUT_GRID_YZ) != FKUT_NO_GUIDE) {
		scene->entryModel(&gridModel[2]);
	}

	return;
}

void fkut_GuideObject::removeScene(fk_Scene *scene, fkut_GuideMode mode)
{
	if((mode & FKUT_AXIS_X) != FKUT_NO_GUIDE || mode == FKUT_NO_GUIDE) {
		scene->removeModel(&axisModel[0]);
	}
	if((mode & FKUT_AXIS_Y) != FKUT_NO_GUIDE || mode == FKUT_NO_GUIDE) {
		scene->removeModel(&axisModel[1]);
	}
	if((mode & FKUT_AXIS_Z) != FKUT_NO_GUIDE || mode == FKUT_NO_GUIDE) {
		scene->removeModel(&axisModel[2]);
	}
	if((mode & FKUT_GRID_XZ) != FKUT_NO_GUIDE || mode == FKUT_NO_GUIDE) {
		scene->removeModel(&gridModel[0]);
	}
	if((mode & FKUT_GRID_XY) != FKUT_NO_GUIDE || mode == FKUT_NO_GUIDE) {
		scene->removeModel(&gridModel[1]);
	}
	if((mode & FKUT_GRID_YZ) != FKUT_NO_GUIDE || mode == FKUT_NO_GUIDE) {
		scene->removeModel(&gridModel[2]);
	}
}
