#include "SpriteModel.h"

fkut_SpriteModel::fkut_SpriteModel(void) : fk_Model()
{
	setParent(&pixelBase);

	texShape.setTextureMode(FK_TEX_MODULATE);
	texShape.setTexRendMode(FK_TEX_REND_SMOOTH);
	setShape(&texShape);

	absMate.setAmbDiff(1.0, 1.0, 1.0);
	absMate.setEmission(1.0, 1.0, 1.0);
	absMate.setAlpha(1.0);
	setMaterial(absMate);

	return;
}

fkut_SpriteModel::~fkut_SpriteModel(void)
{
}

void fkut_SpriteModel::MakePixelBase(fk_Window *argWin, fk_Scene *argScn)
{
	fk_Perspective	*pers = NULL;
	fk_Ortho		*orth = NULL;
	double	winH = (double)argWin->h();
	double	halfFovy, putNear;

	if(argScn->getProjection()->getMode() == FK_PERSPECTIVE_MODE) {
		pers = (fk_Perspective *)argScn->getProjection();
		halfFovy = pers->getFovy()*0.5;
		putNear = pers->getNear()+1.0;
	} else {
		return;
	}

	if((fk_Model*)argScn->getCamera() == NULL) return;

	pixelBase.setParent((fk_Model*)argScn->getCamera());
	pixelBase.glMoveTo(0.0, 0.0, -putNear);
	pixelBase.setScale((putNear*tan(halfFovy)*2.0/winH), (putNear*tan(halfFovy)*2.0/winH), 1.0);

	return;
}

void fkut_SpriteModel::setSpriteSize(double width, double height)
{
	if(width < 0.0) width = (double)getImage()->getWidth();
	if(height < 0.0) height = (double)getImage()->getHeight();
	texShape.setTextureSize(width, height);
	return;
}

fk_TexCoord	fkut_SpriteModel::getSpriteSize(void)
{
	return texShape.getTextureSize();
}

bool fkut_SpriteModel::readBMP(const string argFileName)
{
	if(!texShape.readBMP(argFileName)) return false;
	setSpriteSize();
	return true;
}

bool fkut_SpriteModel::readPNG(const string argFileName)
{
	if(!texShape.readPNG(argFileName)) return false;
	setSpriteSize();
	return true;
}

bool fkut_SpriteModel::readJPG(const string argFileName)
{
	if(!texShape.readJPG(argFileName)) return false;
	setSpriteSize();
	return true;
}

void fkut_SpriteModel::setImage(fk_Image &argImage)
{
	texShape.setImage(&argImage);
	setSpriteSize();
	return;
}

fk_Image * fkut_SpriteModel::getImage(void)
{
	return texShape.getImage();
}

bool fkut_SpriteModel::initFont(const string argFontFile)
{
	if(!text.initFont(argFontFile)) return false;

	text.setDPI(96);
	text.setPTSize(18);
	text.setForeColor(1.0, 1.0, 1.0, 1.0);
	text.setBackColor(0.0, 0.0, 0.0, 0.5);
	text.setAlign(FK_ALIGN_CENTER);

	setImage(text);

	return true;
}

void fkut_SpriteModel::drawText(const string argStr, fk_StringCode argCode)
{
	textStr.convert(argStr, argCode);
	text.loadUniStr(&textStr);
	setImage(text);

	return;
}

void fkut_SpriteModel::setSpriteSmoothMode(bool flag)
{
	if(flag) texShape.setTexRendMode(FK_TEX_REND_SMOOTH);
	else texShape.setTexRendMode(FK_TEX_REND_NORMAL);
}

bool fkut_SpriteModel::getSpriteSmoothMode(void)
{
	if(texShape.getTexRendMode() == FK_TEX_REND_SMOOTH) return true;
	return false;
}

void fkut_SpriteModel::setSpriteArea(double left, double top, double width, double height)
{
	double imgWidth  = (double)getImage()->getWidth();
	double imgHeight = (double)getImage()->getHeight();
	if(imgWidth < 8.0 || imgHeight < 8.0 || width < 8.0 || height < 8.0) return;

	fk_TexCoord	lb, rt;

	lb.set(left/imgWidth, 1.0-(top+height)/imgHeight);
	rt.set((left+width)/imgWidth, 1.0-top/imgHeight);
	texShape.setTextureCoord(lb, rt);
	setSpriteSize(width, height);

	return;
}

void fkut_SpriteModel::setPositionLT(double x, double y)
{
	fk_TexCoord	size = getSpriteSize();
	glMoveTo(x + size.x/2.0, y - size.y/2.0, 0.0);
}
