#ifndef _FKP_MOTIONDATA_H_HEADER_
#define _FKP_MOTIONDATA_H_HEADER_

#include <FK/FK.h>

enum fk_MotionInterType {
	LINEAR,
	SPHERE,
	POWER,
	REV_POWER,
	FREEZE,
	HIDE	// <----------------------------------------------------IuWFNĝւΉ̂ߒǉ
};

class CKeyFrameMotion {
	friend class CMotionCharactor;

private:
	vector<fk_Quaternion>		qArray;
	vector<int>					frameArray;
	vector<fk_MotionInterType>	interTypeArray;

	vector<fk_Vector>			basePosArray;

	map<int, string>			objSwapEvents;

	vector<string>				motionInfoStrArray;

	fk_Vector		getInterVec(fk_Vector, fk_Vector, double, fk_MotionInterType = LINEAR);
	fk_Quaternion	getInterQ(fk_Quaternion, fk_Quaternion, double, fk_MotionInterType = LINEAR);

public:
	CKeyFrameMotion();
	~CKeyFrameMotion();

	void init(void);

	void pushKeyFrame(fk_Quaternion, int, fk_MotionInterType, int = -1);			// L[ǉ(q)
	void pushKeyFrame(fk_Quaternion, fk_Vector, int, fk_MotionInterType, int = -1);	// L[ǉ(e)
	bool changeKeyFrame(int, fk_Quaternion, int, fk_MotionInterType);				// L[C(q)
	bool changeKeyFrame(int, fk_Quaternion, fk_Vector, int, fk_MotionInterType);	// L[C(e)
	bool deleteKeyFrame(int);

	bool isBaseMotion(void);					// basePosArray ɒlX^bNĂ true Ԃ

	int getTotalKeyNum(void);					// ̊֐߂L[t[Ԃ(z̃TCY)
	int getTotalFrameNum(void);					// ̊֐߂[Ṽg[^t[Ԃ
	bool getFrameToKeyID(int, int *, int *);	// ^ꂽt[ẘ֐߂̃L[t[ ID Ƃ̒ŉt[ڂԂ

	void setFrameState(int, fk_Model *);	// ^ꂽt[ɕԃ[V𐶐

};

#endif
